<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Flowcash - Investment Platform</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-blue: #013fa4;
            --light-blue: #e6f0ff;
            --dark-blue: #002b73;
            --black: #000000;
            --white: #ffffff;
            --light-gray: #f8f9fa;
            --medium-gray: #e9ecef;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            background-color: var(--white);
            color: var(--black);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            overflow-x: hidden;
            line-height: 1.6;
        }
        
        /* Header Styles */
        header {
            background-color: var(--white);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
            transition: all 0.3s ease;
        }
        
        .header-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
        }
        
        .logo {
            display: flex;
            align-items: center;
        }
        
        .logo img {
            height: 50px;
            margin-right: 10px;
        }
        
        .logo-text {
            font-size: 1.8rem;
            font-weight: 700;
            color: var(--primary-blue);
        }
        
        nav ul {
            display: flex;
            list-style: none;
        }
        
        nav ul li {
            margin-left: 30px;
        }
        
        nav ul li a {
            text-decoration: none;
            color: var(--black);
            font-weight: 600;
            font-size: 1rem;
            transition: color 0.3s ease;
        }
        
        nav ul li a:hover {
            color: var(--primary-blue);
        }
        
        .hamburger {
            display: none;
            flex-direction: column;
            cursor: pointer;
        }
        
        .hamburger span {
            width: 25px;
            height: 3px;
            background-color: var(--black);
            margin: 3px 0;
            transition: 0.3s;
        }
        
        /* Hero Section */
        .hero-section {
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%);
            color: var(--white);
            padding: 150px 0 100px;
            position: relative;
            overflow: hidden;
            margin-top: 80px;
        }
        
        .hero-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .hero-content {
            flex: 1;
            max-width: 550px;
        }
        
        .hero-title {
            font-size: 3.5rem;
            font-weight: 700;
            margin-bottom: 1.5rem;
            line-height: 1.2;
        }
        
        .hero-subtitle {
            font-size: 1.4rem;
            margin-bottom: 2.5rem;
            opacity: 0.9;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 25px;
            border-radius: 8px;
            font-weight: 600;
            font-size: 1.1rem;
            text-decoration: none;
            transition: all 0.3s ease;
            margin-right: 15px;
            margin-bottom: 15px;
        }
        
        .btn-primary {
            background-color: var(--white);
            color: var(--primary-blue);
            border: none;
        }
        
        .btn-outline {
            background-color: transparent;
            color: var(--white);
            border: 2px solid var(--white);
        }
        
        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        }
        
        .hero-image {
            flex: 1;
            max-width: 500px;
            text-align: center;
        }
        
        .hero-image img {
            max-width: 100%;
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
            transition: transform 0.5s ease;
        }
        
        .hero-image:hover img {
            transform: scale(1.03);
        }
        
        /* Section Styles */
        .section {
            padding: 90px 0;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .section-title {
            font-size: 2.8rem;
            font-weight: 700;
            margin-bottom: 1.2rem;
            color: var(--primary-blue);
            text-align: center;
            position: relative;
        }
        
        .section-title::after {
            content: '';
            position: absolute;
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background-color: var(--primary-blue);
            border-radius: 2px;
        }
        
        .section-subtitle {
            font-size: 1.2rem;
            color: var(--medium-gray);
            text-align: center;
            max-width: 700px;
            margin: 0 auto 4rem;
        }
        
        /* About Section */
        .about-section {
            background-color: var(--light-gray);
        }
        
        .about-container {
            display: flex;
            align-items: center;
            gap: 50px;
        }
        
        .about-image {
            flex: 1;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }
        
        .about-image img {
            width: 100%;
            height: auto;
            transition: transform 0.5s ease;
        }
        
        .about-image:hover img {
            transform: scale(1.05);
        }
        
        .about-content {
            flex: 1;
        }
        
        .about-content h2 {
            font-size: 2.5rem;
            color: var(--primary-blue);
            margin-bottom: 1.5rem;
        }
        
        .about-content p {
            font-size: 1.1rem;
            margin-bottom: 1.5rem;
            color: var(--black);
        }
        
        /* Packages Section */
        .packages-section {
            background-color: var(--white);
        }
        
        .packages-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 30px;
            margin-top: 40px;
        }
        
        .package-card {
            background-color: var(--white);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            padding: 2.5rem;
            height: 100%;
            transition: all 0.3s ease;
            border-top: 5px solid var(--primary-blue);
            position: relative;
            overflow: hidden;
        }
        
        .package-card::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100px;
            height: 100px;
            background-color: var(--light-blue);
            border-radius: 50%;
            transform: translate(30px, -50px);
            z-index: 0;
            opacity: 0.5;
        }
        
        .package-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 40px rgba(1, 63, 164, 0.15);
        }
        
        .package-header {
            text-align: center;
            margin-bottom: 2rem;
            position: relative;
            z-index: 1;
        }
        
        .package-icon {
            width: 70px;
            height: 70px;
            background-color: var(--light-blue);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
        }
        
        .package-icon i {
            font-size: 2rem;
            color: var(--primary-blue);
        }
        
        .package-title {
            font-size: 1.8rem;
            font-weight: 700;
            color: var(--primary-blue);
            margin-bottom: 0.5rem;
        }
        
        .package-details {
            list-style: none;
            padding: 0;
            margin: 0 0 2rem;
            position: relative;
            z-index: 1;
        }
        
        .package-details li {
            padding: 1rem 0;
            border-bottom: 1px solid var(--light-gray);
            display: flex;
            align-items: center;
            font-size: 1.1rem;
        }
        
        .package-details li:last-child {
            border-bottom: none;
        }
        
        .package-details li i {
            color: var(--primary-blue);
            margin-right: 1rem;
            font-size: 1.3rem;
            width: 24px;
            text-align: center;
        }
        
        .package-cta {
            text-align: center;
            position: relative;
            z-index: 1;
        }
        
        /* Testimonials Section */
        .testimonials-section {
            background-color: var(--light-gray);
        }
        
        .testimonials-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
            margin-top: 40px;
        }
        
        .testimonial-card {
            background-color: var(--white);
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
        }
        
        .testimonial-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }
        
        .testimonial-text {
            font-style: italic;
            margin-bottom: 1.5rem;
            color: var(--medium-gray);
        }
        
        .testimonial-author {
            display: flex;
            align-items: center;
        }
        
        .author-avatar {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            margin-right: 15px;
            object-fit: cover;
        }
        
        .author-info h4 {
            margin: 0;
            font-size: 1.1rem;
            color: var(--primary-blue);
        }
        
        .author-info p {
            margin: 0;
            font-size: 0.9rem;
            color: var(--medium-gray);
        }
        
        /* CTA Section */
        .cta-section {
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%);
            color: var(--white);
            padding: 90px 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .cta-section::before {
            content: '';
            position: absolute;
            top: -50px;
            left: -50px;
            width: 200px;
            height: 200px;
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .cta-section::after {
            content: '';
            position: absolute;
            bottom: -70px;
            right: -70px;
            width: 250px;
            height: 250px;
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .cta-title {
            font-size: 2.8rem;
            font-weight: 700;
            margin-bottom: 1.5rem;
            position: relative;
            z-index: 1;
        }
        
        .cta-subtitle {
            font-size: 1.3rem;
            margin-bottom: 2.5rem;
            max-width: 700px;
            margin-left: auto;
            margin-right: auto;
            position: relative;
            z-index: 1;
        }
        
        .btn-white {
            background-color: var(--white);
            color: var(--primary-blue);
            border: none;
            border-radius: 8px;
            padding: 12px 30px;
            font-weight: 600;
            font-size: 1.2rem;
            transition: all 0.3s ease;
            display: inline-block;
            position: relative;
            z-index: 1;
        }
        
        /* Footer */
        footer {
            background-color: var(--dark-blue);
            color: var(--white);
            padding: 70px 0 20px;
        }
        
        .footer-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 40px;
        }
        
        .footer-column h3 {
            font-size: 1.5rem;
            margin-bottom: 20px;
            color: var(--white);
        }
        
        .footer-column ul {
            list-style: none;
        }
        
        .footer-column ul li {
            margin-bottom: 10px;
        }
        
        .footer-column ul li a {
            color: var(--white);
            text-decoration: none;
            transition: color 0.3s ease;
        }
        
        .footer-column ul li a:hover {
            color: var(--light-blue);
        }
        
        .social-icons {
            display: flex;
            gap: 15px;
            margin-top: 20px;
        }
        
        .social-icons a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            color: var(--white);
            transition: all 0.3s ease;
        }
        
        .social-icons a:hover {
            background-color: var(--primary-blue);
            transform: translateY(-3px);
        }
        
        .copyright {
            text-align: center;
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.7);
        }
        
        /* Responsive Styles */
        @media (max-width: 992px) {
            .hero-title {
                font-size: 2.8rem;
            }
            
            .section-title {
                font-size: 2.3rem;
            }
            
            .testimonials-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .footer-container {
                grid-template-columns: repeat(2, 1fr);
            }
        }
        
        @media (max-width: 768px) {
            .hamburger {
                display: flex;
            }
            
            nav ul {
                position: fixed;
                left: -100%;
                top: 70px;
                flex-direction: column;
                background-color: var(--white);
                width: 100%;
                text-align: center;
                transition: 0.3s;
                box-shadow: 0 10px 27px rgba(0, 0, 0, 0.05);
                padding: 20px 0;
            }
            
            nav ul.active {
                left: 0;
            }
            
            nav ul li {
                margin: 15px 0;
            }
            
            .hero-container {
                flex-direction: column;
                text-align: center;
            }
            
            .hero-content {
                margin-bottom: 40px;
            }
            
            .hero-title {
                font-size: 2.2rem;
            }
            
            .hero-subtitle {
                font-size: 1.1rem;
            }
            
            .btn {
                display: block;
                width: 100%;
                max-width: 300px;
                margin: 0.5rem auto;
            }
            
            .about-container {
                flex-direction: column;
            }
            
            .about-image {
                margin-bottom: 30px;
            }
            
            .packages-grid {
                grid-template-columns: 1fr;
            }
            
            .testimonials-grid {
                grid-template-columns: 1fr;
            }
            
            .footer-container {
                grid-template-columns: 1fr;
                text-align: center;
            }
            
            .social-icons {
                justify-content: center;
            }
        }
        
        @media (max-width: 576px) {
            .section {
                padding: 60px 0;
            }
            
            .package-card {
                padding: 1.5rem;
            }
            
            .package-title {
                font-size: 1.5rem;
            }
            
            .package-details li {
                font-size: 1rem;
                padding: 0.7rem 0;
            }
            
            .cta-title {
                font-size: 2.2rem;
            }
            
            .cta-subtitle {
                font-size: 1.1rem;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header>
        <div class="header-container">
            <div class="logo">
                <img src="fw.png" alt="Flowcash Logo">
                <span class="logo-text">Flowcash</span>
            </div>
            <nav>
                <ul>
                    <li><a href="#home">Home</a></li>
                    <li><a href="#about">About</a></li>
                    <li><a href="#packages">Packages</a></li>
                    <li><a href="#testimonials">Testimonials</a></li>
                    <li><a href="#contact">Contact</a></li>
                </ul>
            </nav>
            <div class="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="hero-section" id="home">
        <div class="hero-container">
            <div class="hero-content">
                <h1 class="hero-title">Welcome to <span style="color: var(--white); font-weight: 800;">Flowcash</span></h1>
                <p class="hero-subtitle">Secure your financial future with our trusted investment platform. Grow your wealth with confidence and ease.</p>
                <a href="#packages" class="btn btn-primary">View Packages</a>
                <a href="#about" class="btn btn-outline">Learn More</a>
            </div>
            <div class="hero-image">
                <img src="f1.jpg" alt="Flowcash Investment">
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="section about-section" id="about">
        <div class="container">
            <h2 class="section-title">About Flowcash</h2>
            <p class="section-subtitle">Your trusted partner in financial growth and investment success</p>
            
            <div class="about-container">
                <div class="about-image">
                    <img src="f2.jpg" alt="About Flowcash">
                </div>
                <div class="about-content">
                    <h2>Investment Made Simple</h2>
                    <p>Flowcash is a premier investment platform designed to help you grow your wealth through secure and profitable investment opportunities.</p>
                    <p>Our mission is to provide transparent, reliable, and high-yield investment options that cater to both new and experienced investors.</p>
                    <p>With our expert team and cutting-edge technology, we ensure your investments are safe and working hard for you 24/7.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Packages Section -->
    <section class="section packages-section" id="packages">
        <div class="container">
            <h2 class="section-title">Investment Packages</h2>
            <p class="section-subtitle">Choose the investment plan that aligns with your financial goals</p>
            
            <div class="packages-grid">
                <div class="package-card">
                    <div class="package-header">
                        <div class="package-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <h3 class="package-title">Starter Plan</h3>
                    </div>
                    <ul class="package-details">
                        <li><i class="fas fa-calendar-alt"></i> <strong>Duration:</strong> 7 Days</li>
                        <li><i class="fas fa-coins"></i> <strong>Daily Income:</strong> ₦500</li>
                        <li><i class="fas fa-wallet"></i> <strong>Total Earning:</strong> ₦3,500</li>
                        <li><i class="fas fa-money-bill-wave"></i> <strong>Minimum Withdrawal:</strong> ₦1,000</li>
                    </ul>
                    <div class="package-cta">
                        <a href="#" class="btn btn-primary">Invest Now</a>
                    </div>
                </div>
                
                <div class="package-card">
                    <div class="package-header">
                        <div class="package-icon">
                            <i class="fas fa-gem"></i>
                        </div>
                        <h3 class="package-title">Premium Plan</h3>
                    </div>
                    <ul class="package-details">
                        <li><i class="fas fa-calendar-alt"></i> <strong>Duration:</strong> 14 Days</li>
                        <li><i class="fas fa-coins"></i> <strong>Daily Income:</strong> ₦1,200</li>
                        <li><i class="fas fa-wallet"></i> <strong>Total Earning:</strong> ₦16,800</li>
                        <li><i class="fas fa-money-bill-wave"></i> <strong>Minimum Withdrawal:</strong> ₦2,500</li>
                    </ul>
                    <div class="package-cta">
                        <a href="#" class="btn btn-primary">Invest Now</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="section testimonials-section" id="testimonials">
        <div class="container">
            <h2 class="section-title">What Our Investors Say</h2>
            <p class="section-subtitle">Join thousands of satisfied investors growing their wealth with Flowcash</p>
            
            <div class="testimonials-grid">
                <div class="testimonial-card">
                    <p class="testimonial-text">"Flowcash has completely transformed my financial situation. The returns are consistent and the platform is easy to use."</p>
                    <div class="testimonial-author">
                        <img src="https://randomuser.me/api/portraits/men/32.jpg" alt="User" class="author-avatar">
                        <div class="author-info">
                            <h4>Ahmed Tunde</h4>
                            <p>Investor since 2022</p>
                        </div>
                    </div>
                </div>
                
                <div class="testimonial-card">
                    <p class="testimonial-text">"I've tried several investment platforms, but Flowcash offers the best returns and most reliable customer support."</p>
                    <div class="testimonial-author">
                        <img src="https://randomuser.me/api/portraits/women/44.jpg" alt="User" class="author-avatar">
                        <div class="author-info">
                            <h4>Chioma Okonjo</h4>
                            <p>Investor since 2023</p>
                        </div>
                    </div>
                </div>
                
                <div class="testimonial-card">
                    <p class="testimonial-text">"The withdrawal process is fast and hassle-free. I've recommended Flowcash to all my friends and family."</p>
                    <div class="testimonial-author">
                        <img src="https://randomuser.me/api/portraits/men/67.jpg" alt="User" class="author-avatar">
                        <div class="author-info">
                            <h4>Emeka Nwosu</h4>
                            <p>Investor since 2021</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section" id="contact">
        <div class="container">
            <h2 class="cta-title">Ready to Grow Your Wealth?</h2>
            <p class="cta-subtitle">Join thousands of satisfied investors who are already earning with Flowcash. Start your journey to financial freedom today!</p>
            <a href="#" class="btn-white">Get Started Now</a>
        </div>
    </section>

    <!-- Footer -->
    <footer>
        <div class="footer-container">
            <div class="footer-column">
                <h3>Flowcash</h3>
                <p>Your trusted partner in financial growth and investment success.</p>
                <div class="social-icons">
                    <a href="#"><i class="fab fa-facebook-f"></i></a>
                    <a href="#"><i class="fab fa-twitter"></i></a>
                    <a href="#"><i class="fab fa-instagram"></i></a>
                    <a href="#"><i class="fab fa-linkedin-in"></i></a>
                </div>
            </div>
            
            <div class="footer-column">
                <h3>Quick Links</h3>
                <ul>
                    <li><a href="#home">Home</a></li>
                    <li><a href="#about">About Us</a></li>
                    <li><a href="#packages">Packages</a></li>
                    <li><a href="#testimonials">Testimonials</a></li>
                </ul>
            </div>
            
            <div class="footer-column">
                <h3>Legal</h3>
                <ul>
                    <li><a href="#">Terms of Service</a></li>
                    <li><a href="#">Privacy Policy</a></li>
                    <li><a href="#">Disclaimer</a></li>
                    <li><a href="#">FAQ</a></li>
                </ul>
            </div>
            
            <div class="footer-column">
                <h3>Contact Us</h3>
                <ul>
                    <li><i class="fas fa-map-marker-alt"></i> 123 Investment Street, Lagos, Nigeria</li>
                    <li><i class="fas fa-phone"></i> +234 800 123 4567</li>
                    <li><i class="fas fa-envelope"></i> info@flowcash.com</li>
                </ul>
            </div>
        </div>
        
        <div class="copyright">
            <p>&copy; 2023 Flowcash. All rights reserved.</p>
        </div>
    </footer>

    <script>
        // Hamburger Menu Toggle
        const hamburger = document.querySelector('.hamburger');
        const navMenu = document.querySelector('nav ul');
        
        hamburger.addEventListener('click', () => {
            hamburger.classList.toggle('active');
            navMenu.classList.toggle('active');
        });
        
        // Close menu when clicking on a link
        document.querySelectorAll('nav ul li a').forEach(link => {
            link.addEventListener('click', () => {
                hamburger.classList.remove('active');
                navMenu.classList.remove('active');
            });
        });
        
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });
    </script>
</body>
</html>