<?php
$genMsg=$profileMsg=$passwordMsg=$currPswErr=$newPswErr=$confirmPswErr=$currPsw=$newPsw=$confirmPsw=$btcAddress=$ethAddress=$phone="";

if(isset($_POST['updatePsw'])){

    if(!empty($_POST['currPsw'])){
        $currPsw=$_POST['currPsw'];
    }
    if(!empty($_POST['newPsw'])){
        $newPsw=$_POST['newPsw'];
    }
    if(!empty($_POST['confirmPsw'])){
        $confirmPsw=$_POST['confirmPsw'];
    }  


    if(empty($_POST['currPsw'])){
        $status="error";
        $message="Enter your current password"; 
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['newPsw'])){
        $status="error";
        $message="Enter your new password";
        $genMsg=sendResponse($status, $message);
    }
    else if(strlen($_POST['newPsw']) < 8){
        $status="error";
        $message="Password must be at least 8 characters";
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['confirmPsw'])){
        $status="error";
        $message="Confirm your password";
        $genMsg=sendResponse($status, $message);
    }
    else if($_POST['newPsw'] != $_POST['confirmPsw']){
        $status="error";
        $message="Passwords does not match";
        $genMsg=sendResponse($status, $message);
    }
    else{
        $currPsw=filter_string($_POST['currPsw']);
        $password=sha1($currPsw);

    
        if(!password_verify($password, $hashedPassword)){
            $status="error";
            $message="Current password is incorrect";
            $genMsg=sendResponse($status, $message);   
        }
        else{
            $newPsw=filter_string($_POST['newPsw']);
            $password=sha1($newPsw);
            
            $password=password_hash($password, PASSWORD_DEFAULT);
            $sql=$link->prepare("UPDATE users SET password=? WHERE username=?");
            $sql->bind_param("ss", $password, $username);
            if($sql->execute()){
                $status="success";
                $message="Password has been updated";
                $genMsg=sendResponse($status, $message);
            }
            else{
                $status="error";
                $message="Failed to update password";
                $genMsg=sendResponse($status, $message);
            }        
        }
    }
}


if(isset($_POST['saveBankDetails'])){

   

    if(!empty($_POST['bankName'])){
        $bankName=$_POST['bankName'];
    }
    if(!empty($_POST['acctName'])){
        $acctName=$_POST['acctName'];
    }
    if(!empty($_POST['acctNum'])){
        $acctNum=$_POST['acctNum'];
    }

    if(empty($_POST['bankName'])){
        $status="error";
        $message="Enter your bank name"; 
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['acctName'])){
        $status="error";
        $message="Enter your account name";
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['acctNum'])){
        $status="error";
        $message="Enter your account number";
        $genMsg=sendResponse($status, $message);
    }
    else{
        $bankName=filter_string($_POST['bankName']);
        $acctName=filter_string($_POST['acctName']);
        $acctNum=filter_string($_POST['acctNum']);

        $sql=$link->prepare("SELECT * FROM bankaccounts WHERE username=?");
        $sql->bind_param("s", $username);
        $sql->execute();
        $result=$sql->get_result();
        $numrow=$result->num_rows;
        

        if($numrow == 0){
            $sql=$link->prepare("INSERT INTO bankaccounts(username, bankname, acctname, acctnum, date) VALUES(?,?,?,?,?)");
            $sql->bind_param("sssss", $username, $bankName, $acctName, $acctNum, $dateTime);
        }
        else{
            $sql=$link->prepare("UPDATE bankaccounts SET  bankname=?, acctname=?, acctnum=? WHERE username=?");
            $sql->bind_param("ssss", $bankName, $acctName, $acctNum, $username);
        }
        if($sql->execute()){
            $status="success";
            $message="Bank Details has been saved";
            $genMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Failed to save details";
            $genMsg=sendResponse($status, $message);
        }
    }
}


if(isset($_POST['updateProfile'])){

    if(!empty($_POST['fullname'])){
        $fullname=$_POST['fullname'];
    }
    if(!empty($_POST['phone'])){
        $phoneNumber=$_POST['phone'];
    }

    if(empty($_POST['fullname'])){
        $status="error";
        $message="Enter your fullname";
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['phone'])){
        $status="error";
        $message="Enter your phone number";
        $genMsg=sendResponse($status, $message);
    }
    else if(strlen($_POST['phone']) != 11){
        $status="error";
        $message="Invalid phone number";
        $genMsg=sendResponse($status, $message);
    }
    else{
        $fullname=filter_string($_POST['fullname']);
        $phone=filter_string($_POST['phone']);

        if(isset($_FILES['image']['name']) && $_FILES['image']['error'] == 0){
            $imageName=$_FILES['image']['name'];
            $imageType=$_FILES['image']['type'];
            $imageTmpName=$_FILES['image']['tmp_name'];
            $imageSize=$_FILES['image']['size'];
            $imgExtArr=explode(".", $imageName);
            $newImgName=get_rand_alphanumeric(10).".".end($imgExtArr);
            $allowed=array("png" => "image/png", "jpeg" => "image/jpeg", "jpg" => "image/jpg", "heic" => "application/octet-stream");
            $maxSize=5 * 1024 * 1024;
            $extension=strtolower(pathinfo($imageName, PATHINFO_EXTENSION));
            if(!array_key_exists($extension, $allowed)){
                $status="error";
                $message="File is not an image";
                $genMsg=sendResponse($status, $message);   
            }
            else if(!in_array($imageType, $allowed)){
                $status="error";
                $message="File is not an image";
                $genMsg=sendResponse($status, $message);   
            }
            else if($imageSize > $maxSize){
                $status="error";
                $message="Image is too big, max size: 5MB";
                $genMsg=sendResponse($status, $message);   
            }
            else{
                $sql=$link->prepare("UPDATE users SET fullname=?, phone=? WHERE username=?");
                $sql->bind_param("sss", $fullname, $phone, $username);
                if($sql->execute()){
                    $sql=$link->prepare("UPDATE users SET image=? WHERE username=?");
                    $sql->bind_param("ss", $newImgName, $username);
                    $oldPath=$_SERVER['DOCUMENT_ROOT']."$stream/user/assets/images/profilephoto/$userImage";
                    unlink($oldPath);
                    
                    $sql->execute();

                    $path=$_SERVER['DOCUMENT_ROOT']."$stream/user/assets/images/profilephoto/$newImgName";
                    move_uploaded_file($imageTmpName, $path);
                    $userImage=$newImgName;

                    $status="success";
                    $message="User Details has been saved";
                    $genMsg=sendResponse($status, $message);
                }
                else{
                    $status="error";
                    $message="Failed to save details";
                    $genMsg=sendResponse($status, $message);
                }  
            }
        }
        else{
            $sql=$link->prepare("UPDATE users SET fullname=?, phone=? WHERE username=?");
            $sql->bind_param("sss", $fullname, $phone, $username);
            if($sql->execute()){
                $status="success";
                $message="User Details has been saved";
                $genMsg=sendResponse($status, $message);
            }
            else{
                $status="error";
                $message="Failed to save details";
                $genMsg=sendResponse($status, $message);
            }
        }
    }
}


if(isset($_POST['deleteImg'])){
    $sql=$link->prepare("DELETE FROM profilephotos WHERE username=?");
    $sql->bind_param("s", $username);
    if($sql->execute()){
        if($userImage != "user.jpg"){
            $oldPath=$_SERVER['DOCUMENT_ROOT']."$stream/user/assets/images/profilephoto/$userImage";
            unlink($oldPath);
        }
        $userImage="user.jpg";
        $status="success";
        $message="Profile photo deleted";
        $genMsg=sendResponse($status, $message);
    }
    
}

if(isset($_POST['updateProfileLinks'])){

    if(!empty($_POST['fbLink'])){
        $fbLink=$_POST['fbLink'];
    }   
    if(!empty($_POST['igLink'])){
        $igLink=$_POST['igLink'];
    }
    if(!empty($_POST['ytLink'])){
        $ytLink=$_POST['ytLink'];
    }
    if(!empty($_POST['twLink'])){
        $twLink=$_POST['twLink'];
    }   

    if(empty($_POST['fbLink'])){
        $status="error";
        $message="Enter your facebook profile link";
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['twLink'])){
        $status="error";
        $message="Enter your twitter link";
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['igLink'])){
        $status="error";
        $message="Enter your instagram link";
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['ytLink'])){
        $status="error";
        $message="Enter your youtube link";
        $genMsg=sendResponse($status, $message);
    }
    else{
        $fbLink=filter_string($_POST['fbLink']);
        $twLink=filter_string($_POST['twLink']);
        $igLink=filter_string($_POST['igLink']);
        $ytLink=filter_string($_POST['ytLink']);

        $sql=$link->prepare("SELECT * FROM profilelinks WHERE username=?");
        $sql->bind_param("s", $username);
        $sql->execute();
        $result=$sql->get_result();
        $numrow=$result->num_rows;

        if($numrow == 0){
            $sql=$link->prepare("INSERT INTO profilelinks(username, type, url, date) VALUES(?,?,?,?)");
            $sql->bind_param("ssss", $username, $type, $url, $dateTime);

            $type="facebook";
            $url=$fbLink;
            $sql->execute();
            $type="twitter";
            $url=$twLink;
            $sql->execute();
            $type="youtube";
            $url=$ytLink;
            $sql->execute();
            $type="instagram";
            $url=$igLink;
            $sql->execute();
        }
        else{
            $sql=$link->prepare("UPDATE profilelinks SET url=? WHERE username=? AND type=?");
            $sql->bind_param("sss", $url, $username, $type);

            $type="facebook";
            $url=$fbLink;
            $sql->execute();
            $type="twitter";
            $url=$twLink;
            $sql->execute();
            $type="youtube";
            $url=$ytLink;
            $sql->execute();
            $type="instagram";
            $url=$igLink;
            $sql->execute();
        }
        
        $status="success";
        $message="Profile links has been saved";
        $genMsg=sendResponse($status, $message);
    }
}
?>