<?php
$sql=$link->prepare("SELECT * FROM sponsoredpost WHERE SUBSTRING(date, 1, 10) = ? ");
$sql->bind_param("s", $date);
$sql->execute();
$result=$sql->get_result();
$numrow_task=$result->num_rows;
$row=$result->fetch_assoc();
$title=$image=$desc=$addMsg=$url="";

if($numrow_task > 0){
    $title=$row['title'];    
    $amount=$sponsoredPostAmt;
    $desc=$row['description'];
    $image=$row['image'];
    $postUrl=$row['url'];
    $shareToWhatsapp=$row['type'];
    
    if($shareToWhatsapp =="yes"){
        $shareToWhatsapp=true;
    }
    else{
        $shareToWhatsapp=false;
    }
    
}
else{
    $title="No daily task avaliable yet";
    $amount=0;
    $desc="There is no task avaliable at the moment, check back later";
}

$sql=$link->prepare("SELECT * FROM usersponsored WHERE SUBSTRING(date, 1, 10) = ? AND username=?");
$sql->bind_param("ss", $date, $username);
$sql->execute();
$result=$sql->get_result();
$numrow_userTask=$result->num_rows;
if($numrow_userTask > 0){
    $desc="You have performed the sponsored post task for today, wait till tomorrow for a new one";
}



if(isset($_POST['addTask'])){
    if($numrow_userTask > 0){
        $status="error";
        $message="You have performed this sponsored post task ";
        $addMsg=sendResponse($status, $message);
    }
    else if($numrow_task == 0){
        $status="error";
        $message="Sponsored post not found";
        $addMsg=sendResponse($status, $message);
    }
    else{
        $amount=$sponsoredPostAmt;
        $sql=$link->prepare("INSERT INTO usersponsored(username, title, date) VALUES(?,?,?)");
        $sql->bind_param("sss", $username, $title, $dateTime);
        if($sql->execute()){
            $sql=$link->prepare("UPDATE users SET funds=funds + ? WHERE username=?");
            $sql->bind_param("ss", $amount, $username);
            $sql->execute();

            $status="success";
            $message="Sponsored post completed successfully";
            $addMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong";
            $addMsg=sendResponse($status, $message);
        }
    }
}
?>