<?php
if(isset($_POST['addTask'])){
    if(empty($_POST['reference'])){
        $status="error";
        $message="Something went wrong";
        $addMsg=sendResponse($status, $message);
    }
    else{
        $reference=filter_string($_POST['reference']);
        $sql=$link->prepare("SELECT * FROM  usertasks WHERE username=? AND reference=?");
        $sql->bind_param("ss", $username, $reference);
        $sql->execute();
        $result=$sql->get_result();
        $numrow_userTask=$result->num_rows;
        
        $sql=$link->prepare("SELECT * FROM dailytasks WHERE reference=?");
        $sql->bind_param("s", $reference);
        $sql->execute();
        $result=$sql->get_result();
        $numrow_task=$result->num_rows;
        $row=$result->fetch_assoc();
    
        if($numrow_userTask > 0){
            $status="error";
            $message="You have performed this task";
            $addMsg=sendResponse($status, $message);
        }
        else if($numrow_task == 0){
            $status="error";
            $message="Invalid task";
            $addMsg=sendResponse($status, $message);
        }
        else{
            $amount=$taskAmt;
            $postTitle=$row['title'];    
            $postUrl=$row['url'];    

            $sql=$link->prepare("INSERT INTO usertasks(username, title, url, amount, reference, date) VALUES(?,?,?,?,?,?)");
            $sql->bind_param("ssssss", $username, $postTitle, $postUrl, $amount, $reference, $dateTime);
            if($sql->execute()){
                $sql=$link->prepare("UPDATE users SET funds=funds + ? WHERE username=?");
                $sql->bind_param("ss", $amount, $username);
                $sql->execute();
    
                $status="success";
                $message="Task earnings successfully added";
                $addMsg=sendResponse($status, $message);
            }
            else{
                $status="error";
                $message="Something went wrong";
                $addMsg=sendResponse($status, $message);
            }
        }
    }
}

?>