<?php
$title=$desc=$titleErr=$descErr=$taskMsg=$urlErr=$url="";

if(isset($_POST['postTask'])){

    $sql=$link->prepare("SELECT * FROM dailytasks WHERE SUBSTRING(date, 1, 10) = ?");
    $sql->bind_param("s", $date);
    $sql->execute();
    $result=$sql->get_result();
    $numrow=$result->num_rows;

    if(!empty($_POST['title'])){
        $title=$_POST['title'];
    }
    if(!empty($_POST['desc'])){
        $desc=$_POST['desc'];
    }
    if(!empty($_POST['url'])){
        $url=$_POST['url'];
    }

    if(empty($_POST['title'])){
        $status="error";
        $message="Enter post title"; 
        $titleErr=sendResponse($status, $message);
    }
    else if(empty($_POST['url'])){
        $status="error";
        $message="Enter post url"; 
        $urlErr=sendResponse($status, $message);
    }
    else if(empty($_POST['desc'])){
        $status="error";
        $message="Enter post description"; 
        $descErr=sendResponse($status, $message);
    }
    
    else if($numrow > 0){
        $status="error";
        $message="Daily task for today already exists"; 
        $taskMsg=sendResponse($status, $message);
    }
    else{
        $title=filter_string($_POST['title']);
        $desc=filter_string($_POST['desc']);
        $url=filter_string($_POST['url']);
        $sql=$link->prepare("INSERT INTO dailytasks(title, description, url, date) VALUES(?,?,?,?)");
        $sql->bind_param("ssss", $title, $desc, $url, $dateTime);
        if($sql->execute()){
            $status="success";
            $message="Daily task added";
            $taskMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong";
            $taskMsg=sendResponse($status, $message);
        }
    }
}

if(isset($_POST['deletePost'])){
    if(empty($_POST['id'])){
        $status="error";
        $message="Something went wrongk"; 
        $taskMsg=sendResponse($status, $message);
    } 
    else{
        $id=filter_string($_POST['id']);
        $sql=$link->prepare("DELETE FROM dailytasks WHERE id=?");
        $sql->bind_param("i", $id);
        if($sql->execute()){
            $status="success";
            $message="Sponsored post deleted";
            $taskMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong";
            $taskMsg=sendResponse($status, $message);
        }    
    } 
}
?>