<?php
$genMsg=$videoID=$title=$amount=$desc="";

if(isset($_POST['uploadVideo'])){

    $sql=$link->prepare("SELECT * FROM video WHERE SUBSTRING(date, 1, 10) = ?");
    $sql->bind_param("s", $date);
    $sql->execute();
    $result=$sql->get_result();
    $numrow=$result->num_rows;

    if(!empty($_POST['title'])){
        $title=$_POST['title'];
    }
    if(!empty($_POST['videoID'])){
        $videoID=$_POST['videoID'];
    }
    if(!empty($_POST['amount'])){
        $amount=$_POST['amount'];
    }
    if(!empty($_POST['desc'])){
        $desc=$_POST['desc'];
    }
    
    if(empty($_POST['title'])){
        $status="error";
        $message="Enter post title"; 
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['videoID'])){
        $status="error";
        $message="Enter video ID";
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['amount'])){
        $status="error";
        $message="Enter video amount";
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['desc'])){
        $status="error";
        $message="Enter video description";
        $genMsg=sendResponse($status, $message);
    }
    else if($numrow > 0){
        $status="error";
        $message="Video for today already exists"; 
        $genMsg=sendResponse($status, $message);
    }
    else{
        $title=filter_string($_POST['title']);
        $videoID=filter_string($_POST['videoID']);
        $amount=filter_string($_POST['amount']);
        $desc=filter_string($_POST['desc']);
        $url="https://www.youtube.com/embed/".$videoID;
        $reference=get_rand_alphanumeric(20);
        $sql=$link->prepare("INSERT INTO video(title, videoid, url, reference, amount, description, date) VALUES(?,?,?,?,?,?,?)");
        $sql->bind_param("sssssss", $title, $videoID, $url, $reference, $amount, $desc, $dateTime);
        if($sql->execute()){
            $status="success";
            $message="Video added";
            $genMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong";
            $genMsg=sendResponse($status, $message);
        }
        
    }
}

if(isset($_POST['deletePost'])){
    if(empty($_POST['id'])){
        $status="error";
        $message="Something went wrongk"; 
        $genMsg=sendResponse($status, $message);
    } 
    else{
        $id=filter_string($_POST['id']);
        $sql=$link->prepare("DELETE FROM video WHERE id=?");
        $sql->bind_param("i", $id);
        if($sql->execute()){
            $status="success";
            $message="Video deleted";
            $genMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong";
            $genMsg=sendResponse($status, $message);
        }    
    } 
}
?>