<?php
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/user/admin/includes/generalinclude.php";

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if flow_tasks table exists, create if not
 $tableCheck = $link->query("SHOW TABLES LIKE 'flow_tasks'");
if ($tableCheck->num_rows == 0) {
    $createTable = "CREATE TABLE `flow_tasks` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(100) NOT NULL,
        `link` varchar(255) NOT NULL,
        `amount` decimal(10,2) NOT NULL,
        `description` text DEFAULT NULL,
        `status` enum('active','inactive') NOT NULL DEFAULT 'active',
        `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
        `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    if ($link->query($createTable)) {
        $taskMsg = '<div class="alert alert-info">Tasks table created successfully!</div>';
    } else {
        die("Error creating tasks table: " . $link->error);
    }
}

// Check if flow_user_tasks table exists, create if not
 $tableCheck = $link->query("SHOW TABLES LIKE 'flow_user_tasks'");
if ($tableCheck->num_rows == 0) {
    $createTable = "CREATE TABLE `flow_user_tasks` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `user_id` int(11) NOT NULL,
        `task_id` int(11) NOT NULL,
        `status` enum('pending','completed') NOT NULL DEFAULT 'pending',
        `reward_amount` decimal(10,2) NOT NULL,
        `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
        `completed_at` timestamp NULL DEFAULT NULL,
        PRIMARY KEY (`id`),
        KEY `user_id` (`user_id`),
        KEY `task_id` (`task_id`),
        CONSTRAINT `flow_user_tasks_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
        CONSTRAINT `flow_user_tasks_ibfk_2` FOREIGN KEY (`task_id`) REFERENCES `flow_tasks` (`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    $link->query($createTable);
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add new task
    if (isset($_POST['addTask'])) {
        try {
            $name = $_POST['name'];
            $link_url = $_POST['link'];
            $amount = $_POST['amount'];
            $description = $_POST['description'];
            
            $stmt = $link->prepare("INSERT INTO flow_tasks (name, link, amount, description) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssds", $name, $link_url, $amount, $description);
            
            if ($stmt->execute()) {
                $taskMsg = '<div class="alert alert-success">Task added successfully!</div>';
            } else {
                throw new Exception("Database error: " . $stmt->error);
            }
        } catch (Exception $e) {
            $taskMsg = '<div class="alert alert-danger">Error adding task: ' . $e->getMessage() . '</div>';
        }
    }
    
    // Delete task
    if (isset($_POST['deleteTask'])) {
        try {
            $taskId = $_POST['taskId'];
            
            $stmt = $link->prepare("DELETE FROM flow_tasks WHERE id = ?");
            $stmt->bind_param("i", $taskId);
            
            if ($stmt->execute()) {
                $taskMsg = '<div class="alert alert-success">Task deleted successfully!</div>';
            } else {
                throw new Exception("Database error: " . $stmt->error);
            }
        } catch (Exception $e) {
            $taskMsg = '<div class="alert alert-danger">Error deleting task: ' . $e->getMessage() . '</div>';
        }
    }
    
    // Edit task
    if (isset($_POST['editTask'])) {
        try {
            $taskId = $_POST['taskId'];
            $name = $_POST['name'];
            $link_url = $_POST['link'];
            $amount = $_POST['amount'];
            $description = $_POST['description'];
            $status = $_POST['status'];
            
            $stmt = $link->prepare("UPDATE flow_tasks SET name = ?, link = ?, amount = ?, description = ?, status = ? WHERE id = ?");
            $stmt->bind_param("ssdssi", $name, $link_url, $amount, $description, $status, $taskId);
            
            if ($stmt->execute()) {
                $taskMsg = '<div class="alert alert-success">Task updated successfully!</div>';
            } else {
                throw new Exception("Database error: " . $stmt->error);
            }
        } catch (Exception $e) {
            $taskMsg = '<div class="alert alert-danger">Error updating task: ' . $e->getMessage() . '</div>';
        }
    }
}

include "inc/header.php";
?>

<div class="container-fluid">
    <div class="layout-specing">
        <div class="d-md-flex justify-content-between align-items-center">
            <h5 class="mb-0">Advert Management</h5>
            <nav aria-label="breadcrumb" class="d-inline-block mt-2 mt-sm-0">
                <ul class="breadcrumb bg-transparent rounded mb-0 p-0">
                    <li class="breadcrumb-item text-capitalize"><a href="dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item text-capitalize active" aria-current="page">Adverts</li>
                </ul>
            </nav>
        </div>
        
        <?php if (isset($taskMsg)) echo $taskMsg; ?>
        
        <!-- Add Task Form -->
        <div class="card border-0 rounded shadow mt-4">
            <div class="card-body">
                <h5 class="text-md-start text-center mb-0">Add New Advert</h5>
                
                <form method="POST">
                    <div class="row mt-4">
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Advert Name</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="tag" class="fea icon-sm icons"></i>
                                    <input type="text" class="form-control ps-5" placeholder="Advert Name" name="name" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Reward Amount (₦)</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="dollar-sign" class="fea icon-sm icons"></i>
                                    <input type="number" class="form-control ps-5" placeholder="Reward Amount" name="amount" min="1" step="0.01" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label">Advert Link</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="link" class="fea icon-sm icons"></i>
                                    <input type="url" class="form-control ps-5" placeholder="https://example.com" name="link" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label">Description</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="file-text" class="fea icon-sm icons"></i>
                                    <textarea class="form-control ps-5" placeholder="Enter advert description" name="description" rows="3"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-sm-12">
                            <input type="submit" name="addTask" class="btn btn-primary" value="Add Advert">
                        </div>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Tasks Table -->
        <div class="col mt-4 pt-2">
            <div class="component-wrapper rounded shadow">
                <div class="p-4 border-bottom">
                    <h4 class="title mb-0">Existing Adverts</h4>
                </div>
                
                <div class="p-4">
                    <div class="table-responsive bg-white shadow rounded">
                        <table class="table mb-0 table-center">
                            <thead>
                                <tr>
                                    <th scope="col" class="border-bottom">#</th>
                                    <th scope="col" class="border-bottom">Name</th>
                                    <th scope="col" class="border-bottom">Reward</th>
                                    <th scope="col" class="border-bottom">Link</th>
                                    <th scope="col" class="border-bottom">Status</th>
                                    <th scope="col" class="border-bottom">Created</th>
                                    <th scope="col" class="border-bottom">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                try {
                                    $sql = $link->prepare("SELECT * FROM flow_tasks ORDER BY id DESC");
                                    $sql->execute();
                                    $result = $sql->get_result();
                                    
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $id = $row['id'];
                                            $name = $row['name'];
                                            $link_url = $row['link'];
                                            $amount = $row['amount'];
                                            $description = $row['description'];
                                            $status = $row['status'];
                                            $created_at = date('M j, Y', strtotime($row['created_at']));
                                    ?>
                                            <tr>
                                                <th scope="row"><?php echo $id ?></th>
                                                <td><?php echo $name ?></td>
                                                <td>₦<?php echo number_format($amount, 2) ?></td>
                                                <td>
                                                    <a href="<?php echo htmlspecialchars($link_url) ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                                        <i class="fas fa-external-link-alt"></i> Visit
                                                    </a>
                                                </td>
                                                <td>
                                                    <span class="badge bg-<?php echo $status == 'active' ? 'success' : 'danger' ?>">
                                                        <?php echo ucfirst($status) ?>
                                                    </span>
                                                </td>
                                                <td><?php echo $created_at ?></td>
                                                <td>
                                                    <div class="d-flex gap-2 flex-wrap">
                                                        <!-- Edit Task Button -->
                                                        <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editTaskModal<?php echo $id ?>">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </button>
                                                        
                                                        <!-- Delete Button -->
                                                        <form method="post" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this advert?')">
                                                            <input type="hidden" name="taskId" value="<?php echo $id ?>">
                                                            <button type="submit" name="deleteTask" class="btn btn-sm btn-danger">
                                                                <i class="fas fa-trash"></i> Delete
                                                            </button>
                                                        </form>
                                                    </div>
                                                    
                                                    <!-- Edit Task Modal -->
                                                    <div class="modal fade" id="editTaskModal<?php echo $id ?>" tabindex="-1" aria-labelledby="editTaskModalLabel<?php echo $id ?>" aria-hidden="true">
                                                        <div class="modal-dialog modal-lg">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="editTaskModalLabel<?php echo $id ?>">Edit Advert</h5>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <form method="POST">
                                                                        <input type="hidden" name="taskId" value="<?php echo $id ?>">
                                                                        
                                                                        <div class="row">
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Advert Name</label>
                                                                                    <input type="text" class="form-control" name="name" value="<?php echo htmlspecialchars($name) ?>" required>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Reward Amount (₦)</label>
                                                                                    <input type="number" class="form-control" name="amount" value="<?php echo $amount ?>" min="1" step="0.01" required>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Advert Link</label>
                                                                                    <input type="url" class="form-control" name="link" value="<?php echo htmlspecialchars($link_url) ?>" required>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Description</label>
                                                                                    <textarea class="form-control" name="description" rows="3"><?php echo htmlspecialchars($description) ?></textarea>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Status</label>
                                                                                    <select class="form-control" name="status">
                                                                                        <option value="active" <?php echo $status == 'active' ? 'selected' : ''; ?>>Active</option>
                                                                                        <option value="inactive" <?php echo $status == 'inactive' ? 'selected' : ''; ?>>Inactive</option>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                            <button type="submit" name="editTask" class="btn btn-primary">Save Changes</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                    <?php
                                        }
                                    } else {
                                        echo '<tr><td colspan="7" class="text-center">No adverts found</td></tr>';
                                    }
                                } catch (Exception $e) {
                                    echo '<tr><td colspan="7" class="text-center text-danger">Error loading adverts: ' . $e->getMessage() . '</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Task Completions -->
        <div class="col mt-4 pt-2">
            <div class="component-wrapper rounded shadow">
                <div class="p-4 border-bottom">
                    <h4 class="title mb-0">Recent Completions</h4>
                </div>
                
                <div class="p-4">
                    <div class="table-responsive bg-white shadow rounded">
                        <table class="table mb-0 table-center">
                            <thead>
                                <tr>
                                    <th scope="col" class="border-bottom">User</th>
                                    <th scope="col" class="border-bottom">Advert</th>
                                    <th scope="col" class="border-bottom">Reward</th>
                                    <th scope="col" class="border-bottom">Completed</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                try {
                                    $sql = $link->prepare("SELECT ut.*, t.name as task_name, u.username, u.email 
                                                         FROM flow_user_tasks ut 
                                                         JOIN flow_tasks t ON ut.task_id = t.id 
                                                         JOIN users u ON ut.user_id = u.id 
                                                         WHERE ut.status = 'completed'
                                                         ORDER BY ut.completed_at DESC LIMIT 10");
                                    $sql->execute();
                                    $result = $sql->get_result();
                                    
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $username = $row['username'];
                                            $email = $row['email'];
                                            $task_name = $row['task_name'];
                                            $reward_amount = $row['reward_amount'];
                                            $completed_at = date('M j, Y H:i', strtotime($row['completed_at']));
                                    ?>
                                            <tr>
                                                <td>
                                                    <div><?php echo htmlspecialchars($username) ?></div>
                                                    <small class="text-muted"><?php echo htmlspecialchars($email) ?></small>
                                                </td>
                                                <td><?php echo htmlspecialchars($task_name) ?></td>
                                                <td>₦<?php echo number_format($reward_amount, 2) ?></td>
                                                <td><?php echo $completed_at ?></td>
                                            </tr>
                                    <?php
                                        }
                                    } else {
                                        echo '<tr><td colspan="4" class="text-center">No completions found</td></tr>';
                                    }
                                } catch (Exception $e) {
                                    echo '<tr><td colspan="4" class="text-center text-danger">Error loading completions: ' . $e->getMessage() . '</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include "inc/footer.php"; ?>