<?php
// admin_deposit.php
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if flow_deposits table exists, create if not
 $tableCheck = $link->query("SHOW TABLES LIKE 'flow_deposits'");
if ($tableCheck->num_rows == 0) {
    $createTable = "CREATE TABLE `flow_deposits` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `user_id` int(11) NOT NULL,
        `transaction_id` varchar(50) NOT NULL,
        `amount` decimal(10,2) NOT NULL,
        `payment_method` varchar(50) NOT NULL DEFAULT 'Bank Transfer',
        `status` enum('pending','approved','declined') DEFAULT 'pending',
        `proof_image` varchar(255) DEFAULT NULL,
        `admin_notes` text DEFAULT NULL,
        `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        KEY `user_id` (`user_id`),
        KEY `transaction_id` (`transaction_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    if ($link->query($createTable)) {
        $depMsg = '<div class="alert alert-info">Deposits table created successfully!</div>';
    } else {
        die("Error creating deposits table: " . $link->error);
    }
}

// Check if flow_deposit_settings table exists, create if not
 $tableCheck = $link->query("SHOW TABLES LIKE 'flow_deposit_settings'");
if ($tableCheck->num_rows == 0) {
    $createTable = "CREATE TABLE `flow_deposit_settings` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `payment_method` varchar(50) NOT NULL,
        `is_active` tinyint(1) NOT NULL DEFAULT '1',
        `min_amount` decimal(10,2) NOT NULL DEFAULT '1000.00',
        `max_amount` decimal(10,2) NOT NULL DEFAULT '1000000.00',
        `instructions` text DEFAULT NULL,
        `bank_name` varchar(100) DEFAULT NULL,
        `account_name` varchar(100) DEFAULT NULL,
        `account_number` varchar(50) DEFAULT NULL,
        PRIMARY KEY (`id`),
        UNIQUE KEY `payment_method` (`payment_method`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    if ($link->query($createTable)) {
        $depMsg .= '<div class="alert alert-info">Deposit settings table created successfully!</div>';
        
        // Insert default bank transfer method
        $stmt = $link->prepare("INSERT INTO flow_deposit_settings (payment_method, instructions, bank_name, account_name, account_number) VALUES (?, ?, ?, ?, ?)");
        $paymentMethod = 'Bank Transfer';
        $instructions = 'Transfer to the account below and upload proof of payment';
        $bankName = 'Example Bank';
        $accountName = 'Example Account';
        $accountNumber = '1234567890';
        $stmt->bind_param("sssss", $paymentMethod, $instructions, $bankName, $accountName, $accountNumber);
        $stmt->execute();
    } else {
        die("Error creating deposit settings table: " . $link->error);
    }
} else {
    // Check if new columns exist, add if not
    $columnCheck = $link->query("SHOW COLUMNS FROM `flow_deposit_settings` LIKE 'bank_name'");
    if ($columnCheck->num_rows == 0) {
        $link->query("ALTER TABLE `flow_deposit_settings` ADD COLUMN `bank_name` varchar(100) DEFAULT NULL AFTER `instructions`");
        $link->query("ALTER TABLE `flow_deposit_settings` ADD COLUMN `account_name` varchar(100) DEFAULT NULL AFTER `bank_name`");
        $link->query("ALTER TABLE `flow_deposit_settings` ADD COLUMN `account_number` varchar(50) DEFAULT NULL AFTER `account_name`");
        
        // Update existing record
        $link->query("UPDATE flow_deposit_settings SET bank_name = 'Example Bank', account_name = 'Example Account', account_number = '1234567890' WHERE payment_method = 'Bank Transfer'");
    }
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Approve deposit
    if (isset($_POST['approveDeposit'])) {
        try {
            $depositId = $_POST['depositId'];
            
            // Get deposit details
            $getDeposit = $link->prepare("SELECT * FROM flow_deposits WHERE id = ?");
            $getDeposit->bind_param("i", $depositId);
            $getDeposit->execute();
            $depositResult = $getDeposit->get_result();
            $deposit = $depositResult->fetch_assoc();
            
            if ($deposit) {
                $userId = $deposit['user_id'];
                $amount = $deposit['amount'];
                
                // Get current user funds
                $getUserFunds = $link->prepare("SELECT funds FROM users WHERE id = ?");
                $getUserFunds->bind_param("i", $userId);
                $getUserFunds->execute();
                $userFundsResult = $getUserFunds->get_result();
                $userFundsRow = $userFundsResult->fetch_assoc();
                $currentFunds = $userFundsRow ? $userFundsRow['funds'] : 0;
                
                // Update deposit status
                $updateDeposit = $link->prepare("UPDATE flow_deposits SET status = 'approved' WHERE id = ?");
                $updateDeposit->bind_param("i", $depositId);
                $updateDeposit->execute();
                
                // Update user funds
                $newFunds = $currentFunds + $amount;
                $updateUserFunds = $link->prepare("UPDATE users SET funds = ? WHERE id = ?");
                $updateUserFunds->bind_param("di", $newFunds, $userId);
                
                if ($updateUserFunds->execute()) {
                    // Record transaction
                    $transactionId = 'DEP' . time() . rand(1000, 9999);
                    $insertTransaction = $link->prepare("INSERT INTO flow_transactions (user_id, transaction_id, amount, type, description, created_at) VALUES (?, ?, ?, 'deposit', ?, NOW())");
                    $description = "Deposit approved - Transaction ID: " . $deposit['transaction_id'];
                    $insertTransaction->bind_param("idss", $userId, $transactionId, $amount, $description);
                    $insertTransaction->execute();
                    
                    $depMsg = '<div class="alert alert-success">Deposit approved successfully! User funds have been updated.</div>';
                } else {
                    $depMsg = '<div class="alert alert-danger">Error updating user funds: ' . $link->error . '</div>';
                }
            } else {
                throw new Exception("Deposit not found");
            }
        } catch (Exception $e) {
            $depMsg = '<div class="alert alert-danger">Error approving deposit: ' . $e->getMessage() . '</div>';
        }
    }
    
    // Decline deposit
    if (isset($_POST['declineDeposit'])) {
        try {
            $depositId = $_POST['depositId'];
            $adminNotes = $_POST['adminNotes'];
            
            // Update deposit status with notes
            $updateDeposit = $link->prepare("UPDATE flow_deposits SET status = 'declined', admin_notes = ? WHERE id = ?");
            $updateDeposit->bind_param("si", $adminNotes, $depositId);
            $updateDeposit->execute();
            
            $depMsg = '<div class="alert alert-success">Deposit declined successfully.</div>';
        } catch (Exception $e) {
            $depMsg = '<div class="alert alert-danger">Error declining deposit: ' . $e->getMessage() . '</div>';
        }
    }
    
    // Update bank settings
    if (isset($_POST['updateBankSettings'])) {
        try {
            $methodId = $_POST['methodId'];
            $isActive = isset($_POST['isActive']) ? 1 : 0;
            $minAmount = $_POST['minAmount'];
            $maxAmount = $_POST['maxAmount'];
            $instructions = $_POST['instructions'];
            $bankName = $_POST['bankName'];
            $accountName = $_POST['accountName'];
            $accountNumber = $_POST['accountNumber'];
            
            $updateMethod = $link->prepare("UPDATE flow_deposit_settings SET is_active = ?, min_amount = ?, max_amount = ?, instructions = ?, bank_name = ?, account_name = ?, account_number = ? WHERE id = ?");
            $updateMethod->bind_param("iddssssi", $isActive, $minAmount, $maxAmount, $instructions, $bankName, $accountName, $accountNumber, $methodId);
            $updateMethod->execute();
            
            $depMsg = '<div class="alert alert-success">Bank settings updated successfully!</div>';
        } catch (Exception $e) {
            $depMsg = '<div class="alert alert-danger">Error updating bank settings: ' . $e->getMessage() . '</div>';
        }
    }
}

// Get filter parameters
 $statusFilter = isset($_GET['status']) ? $_GET['status'] : '';
 $searchQuery = isset($_GET['search']) ? $_GET['search'] : '';

// Build query for deposits
 $query = "SELECT d.*, u.username, u.email FROM flow_deposits d 
          LEFT JOIN users u ON d.user_id = u.id WHERE 1=1";
 $params = [];
 $types = "";

if (!empty($statusFilter)) {
    $query .= " AND d.status = ?";
    $params[] = $statusFilter;
    $types .= "s";
}

if (!empty($searchQuery)) {
    $query .= " AND (u.username LIKE ? OR d.transaction_id LIKE ? OR d.created_at LIKE ?)";
    $searchParam = "%$searchQuery%";
    $params[] = $searchParam;
    $params[] = $searchParam;
    $params[] = $searchParam;
    $types .= "sss";
}

 $query .= " ORDER BY d.created_at DESC";

// Execute query
if (!empty($params)) {
    $stmt = $link->prepare($query);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    $result = $link->query($query);
}

// Get bank settings
 $bankSettings = $link->query("SELECT * FROM flow_deposit_settings WHERE payment_method = 'Bank Transfer' LIMIT 1");
 $bankData = $bankSettings->fetch_assoc();

// Set default values if bank data not found
if (!$bankData) {
    $bankData = [
        'id' => 0,
        'is_active' => 1,
        'min_amount' => 1000.00,
        'max_amount' => 1000000.00,
        'instructions' => 'Transfer to the account below and upload proof of payment',
        'bank_name' => 'Example Bank',
        'account_name' => 'Example Account',
        'account_number' => '1234567890'
    ];
}

// Debug: Check for pending deposits
 $debugQuery = "SELECT COUNT(*) as pending_count FROM flow_deposits WHERE status = 'pending'";
 $debugResult = $link->query($debugQuery);
 $debugRow = $debugResult->fetch_assoc();
 $pendingCount = $debugRow['pending_count'];

include "inc/header.php";
?>

<style>
  :root {
    --primary-color: #4e73df;
    --primary-dark: #2e59d9;
    --primary-light: #f8f9fc;
    --text-color: #333;
    --bg-color: #f8f9fc;
    --card-bg: #ffffff;
    --card-border: #e3e6f0;
    --shadow: rgba(0, 0, 0, 0.1);
    --card-radius: 12px;
    --transition: all 0.3s ease;
    --success-color: #1cc88a;
    --warning-color: #f6c23e;
    --danger-color: #e74a3b;
  }

  .layout-specing {
    padding: 1.5rem 0;
  }

  .card {
    border-radius: var(--card-radius);
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    border: none;
    margin-bottom: 1.5rem;
  }

  .card-header {
    background-color: transparent;
    border-bottom: 1px solid var(--card-border);
    padding: 1rem 1.5rem;
  }

  .card-title {
    color: var(--primary-color);
    font-weight: 600;
    margin-bottom: 0;
  }

  .card-body {
    padding: 1.5rem;
  }

  .table {
    margin-bottom: 0;
  }

  .table thead th {
    border-bottom: 2px solid var(--primary-color);
    color: var(--primary-color);
    font-weight: 600;
    padding: 0.75rem;
  }

  .table td, .table th {
    padding: 0.75rem;
    vertical-align: middle;
  }

  .badge {
    padding: 0.5rem 0.75rem;
    font-weight: 600;
    border-radius: 0.25rem;
  }

  .btn {
    border-radius: 0.25rem;
    padding: 0.375rem 0.75rem;
    font-weight: 500;
    transition: var(--transition);
  }

  .btn-sm {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
  }

  .btn-primary {
    background-color: var(--primary-color);
    border-color: var(--primary-color);
    color: white;
  }

  .btn-primary:hover {
    background-color: var(--primary-dark);
    border-color: var(--primary-dark);
    color: white;
  }

  .btn-success {
    background-color: var(--success-color);
    border-color: var(--success-color);
    color: white;
  }

  .btn-success:hover {
    background-color: #17a673;
    border-color: #17a673;
    color: white;
  }

  .btn-danger {
    background-color: var(--danger-color);
    border-color: var(--danger-color);
    color: white;
  }

  .btn-danger:hover {
    background-color: #d63384;
    border-color: #d63384;
    color: white;
  }

  .btn-info {
    background-color: #17a2b8;
    border-color: #17a2b8;
    color: white;
  }

  .btn-info:hover {
    background-color: #138496;
    border-color: #138496;
    color: white;
  }

  .btn-secondary {
    background-color: #6c757d;
    border-color: #6c757d;
    color: white;
  }

  .btn-secondary:hover {
    background-color: #5a6268;
    border-color: #5a6268;
    color: white;
  }

  .modal-content {
    border-radius: var(--card-radius);
    border: none;
  }

  .modal-header {
    border-bottom: 1px solid var(--card-border);
    padding: 1rem 1.5rem;
  }

  .modal-title {
    color: var(--primary-color);
    font-weight: 600;
  }

  .modal-body {
    padding: 1.5rem;
  }

  .modal-footer {
    border-top: 1px solid var(--card-border);
    padding: 1rem 1.5rem;
  }

  .form-control {
    border-radius: 0.25rem;
    border: 1px solid var(--card-border);
    padding: 0.375rem 0.75rem;
  }

  .form-control:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
  }

  .form-label {
    font-weight: 600;
    margin-bottom: 0.5rem;
    color: var(--text-color);
  }

  .alert {
    border-radius: var(--card-radius);
    padding: 1rem 1.5rem;
    margin-bottom: 1.5rem;
    border: none;
  }

  .alert-success {
    background-color: var(--success-color);
    color: white;
  }

  .alert-danger {
    background-color: var(--danger-color);
    color: white;
  }

  .alert-info {
    background-color: var(--primary-color);
    color: white;
  }

  .alert-warning {
    background-color: var(--warning-color);
    color: white;
  }

  .modal-body img {
    max-width: 100%;
    border-radius: var(--card-radius);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
  }

  .breadcrumb {
    background-color: transparent;
    margin-bottom: 0;
    padding: 0;
  }

  .breadcrumb-item + .breadcrumb-item::before {
    content: ">";
    color: var(--primary-color);
  }

  .form-switch {
    padding-left: 2.5rem;
  }

  .form-check-input {
    width: 3rem;
    height: 1.5rem;
    margin-left: -2.5rem;
  }

  .form-check-input:checked {
    background-color: var(--primary-color);
    border-color: var(--primary-color);
  }

  .form-check-input:focus {
    border-color: var(--primary-color);
    outline: 0;
    box-shadow: 0 0 0 0.25rem rgba(78, 115, 223, 0.25);
  }

  .form-check-label {
    color: var(--text-color);
  }
</style>

<div class="container-fluid">
    <div class="layout-specing">
        <div class="d-md-flex justify-content-between align-items-center">
            <h5 class="mb-0">Deposit Management</h5>
            <nav aria-label="breadcrumb" class="d-inline-block mt-2 mt-sm-0">
                <ul class="breadcrumb bg-transparent rounded mb-0 p-0">
                    <li class="breadcrumb-item text-capitalize"><a href="dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item text-capitalize active" aria-current="page">Deposits</li>
                </ul>
            </nav>
        </div>
        
        <?php 
        if (isset($depMsg)) echo $depMsg;
        // Debug info - remove after fixing
        if ($pendingCount > 0) {
            echo '<div class="alert alert-warning">Debug: There are ' . $pendingCount . ' pending deposits waiting for approval</div>';
        }
        ?>
        
        <!-- Filters Section -->
        <div class="card">
            <div class="card-body">
                <h5 class="text-md-start text-center mb-0">Filter Deposits</h5>
                
                <form method="GET" class="mt-4">
                    <div class="row">
                        <div class="col-lg-4 col-12">
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select class="form-control" name="status">
                                    <option value="">All Statuses</option>
                                    <option value="pending" <?php echo $statusFilter == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                    <option value="approved" <?php echo $statusFilter == 'approved' ? 'selected' : ''; ?>>Approved</option>
                                    <option value="declined" <?php echo $statusFilter == 'declined' ? 'selected' : ''; ?>>Declined</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Search</label>
                                <input type="text" class="form-control" name="search" placeholder="Username, Transaction ID, or Date" value="<?php echo htmlspecialchars($searchQuery); ?>">
                            </div>
                        </div>
                        
                        <div class="col-lg-2 col-12">
                            <div class="mb-3">
                                <label class="form-label">&nbsp;</label>
                                <div>
                                    <button type="submit" class="btn btn-primary w-100">Apply Filters</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Deposits Table -->
        <div class="card">
            <div class="card-header">
                <h4 class="card-title mb-0">Deposit Requests</h4>
            </div>
            
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Transaction ID</th>
                                <th scope="col">User ID</th>
                                <th scope="col">User</th>
                                <th scope="col">Amount</th>
                                <th scope="col">Payment Method</th>
                                <th scope="col">Status</th>
                                <th scope="col">Date</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if ($result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    $id = $row['id'];
                                    $transactionId = $row['transaction_id'];
                                    $userId = $row['user_id'];
                                    $username = $row['username'] ?? 'Unknown User';
                                    $email = $row['email'] ?? '';
                                    $amount = $row['amount'];
                                    $paymentMethod = $row['payment_method'];
                                    $status = $row['status'];
                                    $created_at = date('M j, Y H:i', strtotime($row['created_at']));
                                    $proofImage = $row['proof_image'];
                                    $adminNotes = $row['admin_notes'];
                                    
                                    $statusBadge = '';
                                    if ($status == 'pending') {
                                        $statusBadge = '<span class="badge bg-warning">Pending</span>';
                                    } elseif ($status == 'approved') {
                                        $statusBadge = '<span class="badge bg-success">Approved</span>';
                                    } else {
                                        $statusBadge = '<span class="badge bg-danger">Declined</span>';
                                    }
                            ?>
                                    <tr>
                                        <th scope="row"><?php echo $id ?></th>
                                        <td><?php echo $transactionId ?></td>
                                        <td><?php echo $userId ?></td>
                                        <td>
                                            <div><?php echo $username ?></div>
                                            <?php if (!empty($email)): ?>
                                            <small class="text-muted"><?php echo $email ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td>₦<?php echo number_format($amount, 2) ?></td>
                                        <td><?php echo $paymentMethod ?></td>
                                        <td><?php echo $statusBadge ?></td>
                                        <td><?php echo $created_at ?></td>
                                        <td>
                                            <div class="d-flex gap-2 flex-wrap">
                                                <!-- View Proof Button -->
                                                <?php if (!empty($proofImage)): ?>
                                                <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#viewProofModal<?php echo $id ?>">
                                                    <i class="fas fa-image"></i> Proof
                                                </button>
                                                
                                                <!-- View Proof Modal -->
                                                <div class="modal fade" id="viewProofModal<?php echo $id ?>" tabindex="-1" aria-labelledby="viewProofModalLabel<?php echo $id ?>" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="viewProofModalLabel<?php echo $id ?>">Payment Proof</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body text-center">
                                                                <div class="proof-image-container">
                                                                    <img src="/uploads/deposits/<?php echo $proofImage ?>" alt="Payment Proof" class="img-fluid">
                                                                </div>
                                                                <div class="proof-actions mt-3">
                                                                    <button class="btn btn-primary" onclick="downloadProof('/uploads/deposits/<?php echo $proofImage ?>', '<?php echo $proofImage ?>')">
                                                                        <i class="fas fa-download"></i> Download
                                                                    </button>
                                                                    <button class="btn btn-secondary" onclick="copyProofImageLink('/uploads/deposits/<?php echo $proofImage ?>')">
                                                                        <i class="fas fa-copy"></i> Copy Link
                                                                    </button>
                                                                </div>
                                                                <?php if (!empty($adminNotes)): ?>
                                                                <div class="mt-3 alert alert-info">
                                                                    <strong>Admin Notes:</strong> <?php echo htmlspecialchars($adminNotes) ?>
                                                                </div>
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                                
                                                <!-- Approve/Decline Buttons for pending deposits -->
                                                <?php if ($status == 'pending'): ?>
                                                <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#approveModal<?php echo $id ?>">
                                                    <i class="fas fa-check"></i> Approve
                                                </button>
                                                
                                                <!-- Approve Modal -->
                                                <div class="modal fade" id="approveModal<?php echo $id ?>" tabindex="-1" aria-labelledby="approveModalLabel<?php echo $id ?>" aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="approveModalLabel<?php echo $id ?>">Approve Deposit</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <p>Are you sure you want to approve this deposit of ₦<?php echo number_format($amount, 2) ?> from <?php echo $username ?>?</p>
                                                                <p>This action will add the funds to the user's account.</p>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                <form method="post" class="d-inline">
                                                                    <input type="hidden" name="depositId" value="<?php echo $id ?>">
                                                                    <button type="submit" name="approveDeposit" class="btn btn-success">Approve Deposit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#declineModal<?php echo $id ?>">
                                                    <i class="fas fa-times"></i> Decline
                                                </button>
                                                
                                                <!-- Decline Modal -->
                                                <div class="modal fade" id="declineModal<?php echo $id ?>" tabindex="-1" aria-labelledby="declineModalLabel<?php echo $id ?>" aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="declineModalLabel<?php echo $id ?>">Decline Deposit</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <form method="post">
                                                                    <input type="hidden" name="depositId" value="<?php echo $id ?>">
                                                                    <div class="mb-3">
                                                                        <label class="form-label">Reason for Decline</label>
                                                                        <textarea class="form-control" name="adminNotes" rows="3" required></textarea>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                        <button type="submit" name="declineDeposit" class="btn btn-danger">Decline Deposit</button>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                            <?php
                                }
                            } else {
                                echo '<tr><td colspan="9" class="text-center">No deposits found</td></tr>';
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <!-- Bank Settings Section -->
        <div class="card">
            <div class="card-header">
                <h4 class="card-title mb-0">Bank Account Settings</h4>
            </div>
            
            <div class="card-body">
                <form method="post">
                    <input type="hidden" name="methodId" value="<?php echo $bankData['id'] ?>">
                    
                    <div class="row">
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="isActive" value="1" <?php echo $bankData['is_active'] ? 'checked' : '' ?>>
                                    <label class="form-check-label">Active</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Minimum Amount (₦)</label>
                                <input type="number" class="form-control" name="minAmount" value="<?php echo $bankData['min_amount'] ?>" min="0" step="0.01" required>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Maximum Amount (₦)</label>
                                <input type="number" class="form-control" name="maxAmount" value="<?php echo $bankData['max_amount'] ?>" min="0" step="0.01" required>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Bank Name</label>
                                <input type="text" class="form-control" name="bankName" value="<?php echo htmlspecialchars($bankData['bank_name'] ?? '') ?>" required>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Account Name</label>
                                <input type="text" class="form-control" name="accountName" value="<?php echo htmlspecialchars($bankData['account_name'] ?? '') ?>" required>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Account Number</label>
                                <input type="text" class="form-control" name="accountNumber" value="<?php echo htmlspecialchars($bankData['account_number'] ?? '') ?>" required>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label">Instructions</label>
                                <textarea class="form-control" name="instructions" rows="3" required><?php echo htmlspecialchars($bankData['instructions'] ?? '') ?></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-end">
                        <button type="submit" name="updateBankSettings" class="btn btn-primary">Update Settings</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function downloadProof(url, filename) {
    const link = document.createElement('a');
    link.href = url;
    link.download = filename;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}

function copyProofImageLink(url) {
    navigator.clipboard.writeText(url).then(() => {
        // Show a temporary success message
        const btn = event.target;
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check"></i> Copied!';
        btn.disabled = true;
        
        setTimeout(() => {
            btn.innerHTML = originalText;
            btn.disabled = false;
        }, 2000);
    }).catch(err => {
        console.error('Failed to copy: ', err);
    });
}
</script>

<?php include "inc/footer.php"; ?>