<?php
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/includes/generalinclude.php";
$ptitle = "Airtime Purchase";

include "includes/header.php"
?>

<div class="nk-content px-0">
    <div class="container">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <nav>
                  
                    <ol class="breadcrumb breadcrumb-arrow">
                        <li class="breadcrumb-item"><a href="/user/">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">VTU Payments</a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo $ptitle ?></li>
                    </ol>
                </nav>
                <div class="response"></div>
                <div class="nk-block">
                    <div class="card">
                        <h5 class="card-header">Convert Earnings to AIRTIME</h5>
                        <?php if($funds > 4250){ ?>
                        <div class="card-body">
                            <form class="row gx-gs gy-4 js-vavlidate floating-feedbacks" novalidate id="jsValidate">
                                <div class="col-12">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <label for="" class="form-label mb-0">Select Nework</label>
                                            <select class="form-control network" id="validationSelectField" required>
                                                <option>Select Nework</option>
                                                <option value="mtn">MTN</option>
                                                <option value="glo">GLO</option>
                                                <option value="airtel">AIRTEL</option>
                                                <option value="9mobile">9MOBILE</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <label for="" class="form-label mb-0">Amount</label>
                                            <select class="form-control amount" id="validationSelectField" required>
                                                <option value=""> </option>
                                                <option value="200">3000</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <label for="" class="form-label mb-0">Phone</label>
                                            <input type="text" class="form-control phone" placeholder="Phone number" id="validationTextField" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary w-100 bs-tooltip proceed">Buy Airtime</button>
                                </div>
                            </form>
                        </div>
                        <?php } else { ?>
                        <div class="card-body">
                            <p class="text-danger">Sorry you need a minimum of ₦4,250 activities balance to convert airtime</p>
                        </div>
                        <?php } ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>


<script>
    $("form").on("submit", function() {
        return false;
    })
    $(".proceed").on("click", function() {
        let amount = $(".amount").val();
        let phone = $(".phone").val();
        let network = $(".network").val();
        let $this = $(this);
        let title, message, icon;
        if (network == "" || network == null) {
            title = "ERROR";
            icon = "error";
            message = "Select your network";
            popup(title, message, icon, false);
        } else if (amount == "") {
            title = "ERROR";
            icon = "error";
            message = "Enter an amount";
            popup(title, message, icon, false);
        } else if (phone == "") {
            title = "ERROR";
            icon = "error";
            message = "Enter your phone number";
            popup(title, message, icon, false);
        } else {
            title = "WARNING";
            icon = "info";
            message = "You are about to buy airtime of NGN" + amount + " " + network + " to " + phone + " Do you want to proceed?";
            popup(title, message, icon, true, $this);
        }


        function popup(title, message, icon, confirm, $this) {
            Swal.fire({
                    title: '<strong>' + title + '</strong>',
                    icon: icon,
                    html: message,
                    showDenyButton: true,
                    confirmButtonText: 'Proceed',
                    denyButtonText: 'Cancel',
                })
                .then((result) => {
                    if (result.isConfirmed && confirm) {

                        $.ajax({
                            url: "actions/topup.php",
                            type: "POST",
                            data: {
                                buyAirtime: "buyAirtime",
                                amount: amount,
                                phone: phone,
                                network: network,
                            },
                            beforeSend: function() {
                                $($this).html("Processing...")
                                $($this).attr("disabled", true);
                            },
                            success: function(data) {
                                $($this).html("<em class='icon ni ni-arrow-right'></em><span> Procced</span>")
                                $($this).attr("disabled", false);
                                $(".response").html(data);
                            }
                        })
                    }
                })
        }
    })
</script>
<?php include "includes/footer.php" ?>