!(function (t) {
  "use strict";
  (t.sweetAlert = {
    basic: function (t, e, o) {
      document.querySelector(t).addEventListener("click", function () {
        Swal.fire({
          icon: e.icon ? e.icon : null,
          title: e.title ? e.title : null,
          text: e.text ? e.text : null,
          showConfirmButton:
            void 0 === e.showConfirmButton || JSON.parse(e.showConfirmButton),
          confirmButtonText: e.confirmButtonText ? e.confirmButtonText : "Ok",
          showCancelButton:
            void 0 !== e.showCancelButton && JSON.parse(e.showCancelButton),
          cancelButtonText: e.cancelButtonText ? e.cancelButtonText : "Cancel",
          position: e.position ? e.position : "center",
          timer: e.timer ? parseInt(e.timer) : void 0,
          timerProgressBar: !!e.timerProgressBar && e.timerProgressBar,
        });
      });
    },
    confirm: function (t, e, o) {
      document.querySelector(t).addEventListener("click", function () {
        Swal.fire({
          icon: e.icon ? e.icon : null,
          title: e.title ? e.title : null,
          text: e.text ? e.text : null,
          showConfirmButton:
            void 0 === e.showConfirmButton || JSON.parse(e.showConfirmButton),
          confirmButtonText: e.confirmButtonText ? e.confirmButtonText : "Ok",
          showCancelButton:
            void 0 !== e.showCancelButton && JSON.parse(e.showCancelButton),
          cancelButtonText: e.cancelButtonText ? e.cancelButtonText : "Cancel",
          position: e.position ? e.position : "center",
          timer: e.timer ? parseInt(e.timer) : void 0,
          timerProgressBar: !!e.timerProgressBar && e.timerProgressBar,
        }).then((t) => {
          t.isConfirmed &&
            Swal.fire({
              icon: o.icon ? o.icon : null,
              title: o.title ? o.title : null,
              text: o.text ? o.text : null,
              showConfirmButton:
                void 0 === o.showConfirmButton ||
                JSON.parse(o.showConfirmButton),
              confirmButtonText: o.confirmButtonText
                ? o.confirmButtonText
                : "Ok",
              showCancelButton:
                void 0 !== o.showCancelButton && JSON.parse(o.showCancelButton),
              cancelButtonText: o.cancelButtonText
                ? o.cancelButtonText
                : "Cancel",
              position: o.position ? o.position : "center",
              timer: o.timer ? parseInt(o.timer) : void 0,
              timerProgressBar: !!o.timerProgressBar && o.timerProgressBar,
            });
        });
      });
    },
    autoClose: function (t, e) {
      document.querySelector(t).addEventListener("click", function () {
        let t;
        Swal.fire({
          icon: e.icon ? e.icon : null,
          title: e.title ? e.title : null,
          text: e.text ? e.text : null,
          html: e.html ? e.html : null,
          showConfirmButton:
            void 0 === e.showConfirmButton || JSON.parse(e.showConfirmButton),
          confirmButtonText: e.confirmButtonText ? e.confirmButtonText : "Ok",
          showCancelButton:
            void 0 !== e.showCancelButton && JSON.parse(e.showCancelButton),
          cancelButtonText: e.cancelButtonText ? e.cancelButtonText : "Cancel",
          position: e.position ? e.position : "center",
          timer: e.timer ? parseInt(e.timer) : void 0,
          timerProgressBar: !!e.timerProgressBar && e.timerProgressBar,
          didOpen: () => {
            Swal.showLoading();
            const e = Swal.getHtmlContainer().querySelector("b");
            t = setInterval(() => {
              e.textContent = Swal.getTimerLeft();
            }, 100);
          },
          willClose: () => {
            clearInterval(t);
          },
        }).then((t) => {
          t.dismiss === Swal.DismissReason.timer &&
            console.log("I was closed by the timer");
        });
      });
    },
    ajaxRequest: function (t, e) {
      document.querySelector(t).addEventListener("click", function () {
        Swal.fire({
          icon: e.icon ? e.icon : null,
          title: e.title ? e.title : null,
          text: e.text ? e.text : null,
          html: e.html ? e.html : null,
          showConfirmButton:
            void 0 === e.showConfirmButton || JSON.parse(e.showConfirmButton),
          confirmButtonText: e.confirmButtonText ? e.confirmButtonText : "Ok",
          showCancelButton:
            void 0 !== e.showCancelButton && JSON.parse(e.showCancelButton),
          cancelButtonText: e.cancelButtonText ? e.cancelButtonText : "Cancel",
          position: e.position ? e.position : "center",
          input: "text",
          inputAttributes: { autocapitalize: "off" },
          showLoaderOnConfirm: !0,
          backdrop: !0,
          preConfirm: (t) =>
            fetch("//api.github.com/users/" + t)
              .then((t) => {
                if (!t.ok) throw new Error(t.statusText);
                return t.json();
              })
              .catch((t) => {
                Swal.showValidationMessage("Request failed: " + t);
              }),
          allowOutsideClick: () => !Swal.isLoading(),
        }).then((t) => {
          t.isConfirmed &&
            Swal.fire({
              title: t.value.name + "'s avatar",
              imageUrl: t.value.avatar_url,
            });
        });
      });
    },
  }),
    (t.sweetAlert.init = function () {
      t.sweetAlert.basic(".eg-swal-default", {
        title: "A Simple sweet alert Content",
      }),
        t.sweetAlert.basic(".eg-swal-success", {
          icon: "success",
          title: "Good job!",
          text: "You clicked the button!",
        }),
        t.sweetAlert.basic(".eg-swal-info", {
          icon: "info",
          title: "Good job!",
          text: "You clicked the button!",
        }),
        t.sweetAlert.basic(".eg-swal-warning", {
          icon: "warning",
          title: "Are you sure?",
          text: "You won't be able to revert this!",
        }),
        t.sweetAlert.basic(".eg-swal-error", {
          icon: "error",
          title: "Oops...",
          text: "Something went wrong!",
        }),
        t.sweetAlert.basic(".eg-swal-question", {
          icon: "question",
          text: "The Internet?",
          title: "That thing is still around?",
        }),
        t.sweetAlert.basic(".eg-swal-positioned", {
          position: "top-end",
          icon: "success",
          title: "Your work has been saved",
          showConfirmButton: !1,
          timer: 1500,
        }),
        t.sweetAlert.confirm(
          ".eg-swal-confirm-button",
          {
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, delete it!",
          },
          {
            icon: "success",
            title: "Deleted!",
            text: "Your file has been deleted.",
          }
        ),
        t.sweetAlert.autoClose(".eg-swal-auto-close-timer", {
          title: "Auto close alert!",
          html: "I will close in <b></b> milliseconds.",
          timer: 2e3,
          timerProgressBar: !0,
        }),
        t.sweetAlert.ajaxRequest(".eg-swal-ajax-request", {
          title: "Submit your Github username",
          showCancelButton: !0,
          confirmButtonText: "Look up",
        });
    }),
    t.winLoad(t.sweetAlert.init);
})(NioApp);
