<?php
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/wave/includes/generalinclude.php";
$ptitle = "Activities Logs";
include "includes/header.php"
?>

<div class="nk-content px-0">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head">
                    <div class="nk-block-head-between flex-wrap gap g-2">
                        <div class="nk-block-head-content">
                            <h2 class="nk-block-title"><?php echo $ptitle ?></h1>
                                <nav>
                                    <ol class="breadcrumb breadcrumb-arrow mb-0">
                                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#"><?php echo $ptitle ?></a></li>
                                    </ol>
                                </nav>
                        </div>
                    </div>
                </div>
                <div class="row g-gs">

                    <div class="bg-white col-12 px-1">
                        <div class="h-100">
                            <div class="flex-grow-0 py-2 px-2">
                                <div class="card-title-group">
                                    <div class="card-title">
                                        <h5 class="title">Activities Logs</h5>
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-middle mb-0">
                                    <tbody>
                                        <?php
                                        $sql = $link->prepare("SELECT * FROM activitylog WHERE username=? ORDER BY id DESC");
                                        $sql->bind_param("s", $username);
                                        $sql->execute();
                                        $result = $sql->get_result();
                                        $numrow = $result->num_rows;
                                        if ($numrow > 0) {
                                            while ($row = $result->fetch_assoc()) {
                                                $type = $row['type'];
                                                $message = $row['description'];
                                                $amount = $row['amount'];
                                                $date = $row['date'];
                                        ?>
                                                <tr class="pointer">
                                                    <td class="tb-col">
                                                        <div class="media-group">
                                                            <div class="media-text"><a class="title text-danger"><?php echo $message ?></a><span class="text smaller"><?php echo $date ?></span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="tb-col tb-col-end">
                                                        <div class="media-text"><a class="title text-success" id="bal">₦<?php echo $amount ?></a></div>
                                                    </td>
                                                </tr>
                                        <?php }
                                        } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>


<?php include "includes/footer.php" ?>