document.getElementById( "copyButton" ).addEventListener( "click", function ()
{
    copyToClipboard( document.getElementById( "refUrl" ).value );
} );

function copyToClipboard ( text )
{
    navigator.clipboard.writeText( text )
        .then( function ()
        {
            showToast( 'Referral link copied!' );
        } )
        .catch( function ()
        {
            showToast( 'Failed to copy link.' );
        } );
}

function showToast ( message )
{
    Toastify( {
        text: message,
        duration: 5000,
        close: false,
        gravity: "top",
        position: "center",
       // avatar: 'images/bills/success.png',
        style: {
            background: 'linear-gradient(to right, #00b09b, #96c93d)',
        },
        stopOnFocus: true,
    } ).showToast();
}