<?php
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/includes/generalinclude.php";
 $ptitle = "My Referrals";

// Determine referral badge based on number of referrals
if ($totalReferrals < 1) {
    $referralBadge = "None";
    $badgeColor = "#6c757d"; // Gray
    $nextBadge = "Beginner";
    $progressPercentage = 0;
    $progressMax = 1;
} elseif ($totalReferrals < 10) {
    $referralBadge = "Beginner";
    $badgeColor = "#75AFEE"; // Gainmart blue
    $nextBadge = "Vendor";
    $progressPercentage = ($totalReferrals / 10) * 100;
    $progressMax = 10;
} else {
    $referralBadge = "Vendor";
    $badgeColor = "#75AFEE"; // Gainmart blue
    $nextBadge = "Expert";
    $progressPercentage = min(100, (($totalReferrals - 10) / 40) * 100);
    $progressMax = 50;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?php echo $sitedesc ?>">
    <title><?php echo $ptitle ?> - <?php echo $sitename ?></title>
    <link rel="shortcut icon" href="../favicon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            /* Gainmart colors */
            --primary-blue: #75AFEE;
            --dark-blue: #4A8FE7;
            --darker-blue: #2E6CBF;
            --black: #000000;
            --dark-gray: #1A1A1A;
            --medium-gray: #2A2A2A;
            --light-gray: #3A3A3A;
            --text-light: #E0E0E0;
            --text-dim: #A0A0A0;
            --card-bg: #1F1F1F;
            --card-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            --input-bg: #2A2A2A;
            --border-color: #3A3A3A;
            --success: #4CAF50;
            --warning: #FFC107;
            --danger: #F44336;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--black);
            color: var(--text-light);
            transition: all 0.3s ease;
            min-height: 100vh;
            padding-bottom: 5rem; /* Added padding for bottom nav */
        }

        h1,h2,h3,h4,h5,h6 {
            font-weight: 700;
        }
        
        .container-fluid {
            width: 100%;
            padding-right: 15px;
            padding-left: 15px;
            margin-right: auto;
            margin-left: auto;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            margin-right: -15px;
            margin-left: -15px;
        }

        .col-12, .col-md-6 {
            position: relative;
            width: 100%;
            padding-right: 15px;
            padding-left: 15px;
        }

        @media (min-width: 768px) {
            .col-md-6 {
                flex: 0 0 50%;
                max-width: 50%;
            }
        }

        .g-gs {
            --bs-gutter-x: 1.5rem;
            --bs-gutter-y: 0;
            display: flex;
            flex-wrap: wrap;
            margin-top: calc(-1 * var(--bs-gutter-y));
            margin-right: calc(-.5 * var(--bs-gutter-x));
            margin-left: calc(-.5 * var(--bs-gutter-x));
        }

        .g-gs > * {
            flex-shrink: 0;
            width: 100%;
            max-width: 100%;
            padding-right: calc(var(--bs-gutter-x) * .5);
            padding-left: calc(var(--bs-gutter-x) * .5);
            margin-top: var(--bs-gutter-y);
        }

        .mt-3 {
            margin-top: 1rem !important;
        }

        .mt-4 {
            margin-top: 1.5rem !important;
        }

        .px-3 {
            padding-left: 1rem !important;
            padding-right: 1rem !important;
        }

        .mb-3 {
            margin-bottom: 1rem !important;
        }

        .mr-2 {
            margin-right: 0.5rem !important;
        }

        /* Header Styles */
        .header {
            background: var(--dark-gray);
            backdrop-filter: blur(10px);
            padding: 1rem 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .logo img {
            height: 40px;
        }

        .logo-text {
            font-size: 1.5rem;
            font-weight: 800;
            color: var(--primary-blue);
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .notification-btn {
            position: relative;
            background: var(--medium-gray);
            border: none;
            color: var(--text-light);
            font-size: 1.2rem;
            cursor: pointer;
            padding: 0.75rem;
            border-radius: 50%;
            transition: all 0.3s ease;
        }

        .notification-btn:hover {
            background: var(--light-gray);
            color: var(--primary-blue);
        }

        .notification-badge {
            position: absolute;
            top: 0;
            right: 0;
            width: 10px;
            height: 10px;
            background: var(--danger);
            border-radius: 50%;
        }

        .account-section {
            position: relative;
        }

        .account-btn {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            background: var(--medium-gray);
            border: none;
            color: var(--text-light);
            cursor: pointer;
            padding: 0.5rem 1rem;
            border-radius: 2rem;
            transition: all 0.3s ease;
        }

        .account-btn:hover {
            background: var(--light-gray);
        }

        .account-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--primary-blue);
        }

        .account-info {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
        }

        .account-name {
            font-weight: 600;
            font-size: 0.9rem;
        }

        .account-username {
            font-size: 0.8rem;
            color: var(--text-dim);
        }

        .account-dropdown {
            position: absolute;
            top: 100%;
            right: 0;
            margin-top: 0.5rem;
            background: var(--dark-gray);
            backdrop-filter: blur(10px);
            border-radius: 0.75rem;
            box-shadow: 0 10px 25px rgba(0,0,0,0.4);
            min-width: 220px;
            overflow: hidden;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.3s ease;
        }

        .account-dropdown.active {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .dropdown-divider {
            height: 1px;
            background: var(--light-gray);
            margin: 0.5rem 0;
        }

        .dropdown-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
            color: var(--text-light);
            text-decoration: none;
            transition: background-color 0.3s;
        }

        .dropdown-item:hover {
            background-color: var(--medium-gray);
        }

        .dropdown-item i {
            font-size: 1.1rem;
            width: 20px;
            text-align: center;
            color: var(--primary-blue);
        }

        /* Bottom Navigation Bar */
        .bottom-navigation {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: var(--dark-gray);
            box-shadow: 0 -2px 10px rgba(0,0,0,0.2);
            z-index: 100;
            padding: 0.75rem 0;
            display: flex;
            justify-content: space-around;
            align-items: center;
        }

        .bottom-nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 0.5rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
            color: var(--text-dim);
            text-decoration: none;
            width: 20%;
        }

        .bottom-nav-item:hover {
            background: var(--medium-gray);
            color: var(--primary-blue);
        }

        .bottom-nav-item.active {
            background: var(--medium-gray);
            color: var(--primary-blue);
        }

        .bottom-nav-icon {
            font-size: 1.5rem;
            margin-bottom: 0.25rem;
        }

        .bottom-nav-text {
            font-size: 0.7rem;
            font-weight: 600;
        }

        /* Right Sidebar Menu */
        .right-sidebar {
            position: fixed;
            top: 0;
            right: -50%; /* Hidden by default - half page width */
            width: 50%; /* Half page width */
            height: 100%;
            background: var(--dark-gray);
            z-index: 1001;
            transition: right 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
            overflow-y: auto;
            box-shadow: -5px 0 25px rgba(0,0,0,0.4);
        }

        .right-sidebar.active {
            right: 0;
        }

        .sidebar-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1.5rem;
            border-bottom: 1px solid var(--light-gray);
            position: relative;
            z-index: 2;
            background: var(--dark-gray);
        }

        .sidebar-logo {
            height: 40px;
            filter: drop-shadow(0 2px 4px rgba(0,0,0,0.3));
        }

        .sidebar-close {
            background: var(--medium-gray);
            border: none;
            color: var(--text-light);
            font-size: 1.5rem;
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }

        .sidebar-close:hover {
            background: var(--light-gray);
            transform: rotate(90deg);
        }

        .sidebar-content {
            padding: 1rem 0;
            position: relative;
            z-index: 2;
            background: var(--dark-gray);
            min-height: calc(100% - 73px); /* Subtract header height */
        }

        .nk-menu {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .nk-menu-item {
            margin: 0.25rem 0;
            opacity: 0;
            transform: translateX(20px);
            animation: slideInRight 0.5s forwards;
        }

        /* Stagger animation for menu items */
        .nk-menu-item:nth-child(1) { animation-delay: 0.1s; }
        .nk-menu-item:nth-child(2) { animation-delay: 0.15s; }
        .nk-menu-item:nth-child(3) { animation-delay: 0.2s; }
        .nk-menu-item:nth-child(4) { animation-delay: 0.25s; }
        .nk-menu-item:nth-child(5) { animation-delay: 0.3s; }
        .nk-menu-item:nth-child(6) { animation-delay: 0.35s; }
        .nk-menu-item:nth-child(7) { animation-delay: 0.4s; }
        .nk-menu-item:nth-child(8) { animation-delay: 0.45s; }
        .nk-menu-item:nth-child(9) { animation-delay: 0.5s; }
        .nk-menu-item:nth-child(10) { animation-delay: 0.55s; }
        .nk-menu-item:nth-child(11) { animation-delay: 0.6s; }
        .nk-menu-item:nth-child(12) { animation-delay: 0.65s; }
        .nk-menu-item:nth-child(13) { animation-delay: 0.7s; }
        .nk-menu-item:nth-child(14) { animation-delay: 0.75s; }
        .nk-menu-item:nth-child(15) { animation-delay: 0.8s; }

        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(20px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .nk-menu-link {
            display: flex;
            align-items: center;
            padding: 0.9rem 1.5rem;
            color: var(--text-light);
            text-decoration: none;
            transition: all 0.3s ease;
            border-radius: 0.75rem;
            margin: 0 0.75rem;
            position: relative;
            overflow: hidden;
        }

        .nk-menu-link::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: var(--primary-blue);
            transform: scaleY(0);
            transition: transform 0.3s ease;
        }

        .nk-menu-link:hover {
            background: var(--medium-gray);
            transform: translateX(5px);
        }

        .nk-menu-link:hover::before {
            transform: scaleY(1);
        }

        .nk-menu-icon {
            margin-right: 1rem;
            color: var(--primary-blue);
            font-size: 1.2rem;
            width: 24px;
            text-align: center;
            transition: transform 0.3s ease;
        }

        .nk-menu-link:hover .nk-menu-icon {
            transform: scale(1.1);
        }

        .nk-menu-text {
            font-weight: 500;
            font-size: 1rem;
        }

        .nk-menu-heading {
            padding: 0.75rem 1.5rem;
            margin: 1.5rem 0 0.75rem;
            color: var(--text-dim);
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            position: relative;
        }

        .nk-menu-heading::after {
            content: '';
            position: absolute;
            bottom: -0.5rem;
            left: 1.5rem;
            right: 1.5rem;
            height: 1px;
            background: var(--light-gray);
        }

        .overline-title {
            font-weight: 600;
        }

        .nk-menu-sub {
            list-style: none;
            padding: 0;
            margin: 0.25rem 0 0.25rem 2rem;
            background: var(--black);
            border-radius: 0.75rem;
            overflow: hidden;
            max-height: 0;
            opacity: 0;
            transition: all 0.4s ease;
        }

        .nk-menu-sub.active {
            max-height: 500px;
            opacity: 1;
        }

        .nk-menu-sub .nk-menu-item {
            margin: 0;
            opacity: 1;
            transform: none;
            animation: none;
        }

        .nk-menu-sub .nk-menu-link {
            padding: 0.7rem 1rem 0.7rem 1.5rem;
            font-size: 0.9rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
        }

        .nk-menu-sub .nk-menu-link::before {
            width: 3px;
        }

        .nk-menu-sub .nk-menu-icon {
            font-size: 1rem;
            margin-right: 0.75rem;
        }

        /* Menu toggle icon animation */
        .nk-menu-toggle .nk-menu-icon::after {
            content: '\f107';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            margin-left: auto;
            transition: transform 0.3s ease;
        }

        .nk-menu-toggle.active .nk-menu-icon::after {
            transform: rotate(180deg);
        }

        /* Overlay for sidebar */
        .sidebar-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.7);
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .sidebar-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        /* Page Title */
        .page-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--text-light);
            margin-bottom: 1.5rem;
            padding: 0 1rem;
        }

        /* Stats Cards */
        .stats-container {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .stat-card {
            background: var(--dark-gray);
            border-radius: 0.75rem;
            padding: 1.25rem;
            box-shadow: var(--card-shadow);
            transition: transform 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0.75rem;
        }

        .stat-title {
            font-size: 0.85rem;
            font-weight: 600;
            color: var(--text-dim);
        }

        .stat-icon {
            width: 36px;
            height: 36px;
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
        }

        .stat-icon.primary {
            background: rgba(117, 175, 238, 0.15);
            color: var(--primary-blue);
        }

        .stat-icon.success {
            background: rgba(76, 175, 80, 0.15);
            color: var(--success);
        }

        .stat-value {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--text-light);
            margin-bottom: 0.25rem;
        }

        /* Referral Link Section */
        .referral-section {
            background: var(--dark-gray);
            border-radius: 0.75rem;
            padding: 1.25rem;
            margin-bottom: 1.5rem;
            box-shadow: var(--card-shadow);
        }

        .section-title {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--text-light);
            margin-bottom: 1.25rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .section-title i {
            color: var(--primary-blue);
        }

        .referral-description {
            font-size: 0.9rem;
            color: var(--text-dim);
            margin-bottom: 1.25rem;
        }

        .referral-input-group {
            display: flex;
            margin-bottom: 1.25rem;
        }

        .referral-input {
            flex: 1;
            background: var(--input-bg);
            border: 1px solid var(--border-color);
            border-radius: 0.5rem 0 0 0.5rem;
            padding: 0.75rem;
            color: var(--text-light);
            font-size: 0.85rem;
        }

        .copy-btn {
            background: var(--primary-blue);
            color: var(--black);
            border: none;
            border-radius: 0 0.5rem 0.5rem 0;
            padding: 0 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .copy-btn:hover {
            background: var(--dark-blue);
        }

        .share-buttons {
            display: flex;
            gap: 0.75rem;
            margin-bottom: 1.25rem;
        }

        .share-btn {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.75rem;
            border-radius: 0.5rem;
            font-weight: 600;
            font-size: 0.85rem;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .share-whatsapp {
            background: #25D366;
            color: white;
        }

        .share-whatsapp:hover {
            transform: translateY(-3px);
        }

        .share-facebook {
            background: #1877F2;
            color: white;
        }

        .share-facebook:hover {
            transform: translateY(-3px);
        }

        .share-twitter {
            background: #1DA1F2;
            color: white;
        }

        .share-twitter:hover {
            transform: translateY(-3px);
        }

        /* Referral Progress */
        .referral-progress {
            margin-top: 1.25rem;
        }

        .badge-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0.75rem;
        }

        .current-badge {
            display: flex;
            align-items: center;
            font-weight: 600;
            color: var(--text-light);
            font-size: 1rem;
        }

        .badge-icon {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            margin-right: 0.5rem;
            background-color: <?php echo $badgeColor; ?>;
            color: white;
        }

        .next-badge {
            font-size: 0.8rem;
            color: var(--text-dim);
            background: var(--medium-gray);
            padding: 0.3rem 0.75rem;
            border-radius: 1rem;
        }

        .progress-container {
            background-color: var(--medium-gray);
            height: 8px;
            border-radius: 10px;
            overflow: hidden;
            margin-bottom: 0.5rem;
        }

        .progress-bar {
            height: 100%;
            background-color: <?php echo $badgeColor; ?>;
            border-radius: 10px;
            width: <?php echo $progressPercentage; ?>%;
            transition: width 1s ease-in-out;
        }

        .progress-text {
            display: flex;
            justify-content: space-between;
            font-size: 0.8rem;
            color: var(--text-dim);
        }

        .progress-current {
            font-weight: 600;
        }

        .progress-max {
            color: var(--text-dim);
        }

        /* Referrals Table */
        .referrals-table {
            background: var(--dark-gray);
            border-radius: 0.75rem;
            padding: 1.25rem;
            box-shadow: var(--card-shadow);
        }

        .table-container {
            overflow-x: auto;
        }

        .referral-table {
            width: 100%;
            border-collapse: collapse;
        }

        .referral-table th {
            text-align: left;
            padding: 0.75rem;
            font-weight: 600;
            color: var(--text-dim);
            border-bottom: 1px solid var(--border-color);
            font-size: 0.85rem;
        }

        .referral-table td {
            padding: 0.75rem;
            border-bottom: 1px solid var(--border-color);
            font-size: 0.9rem;
        }

        .referral-table tr:last-child td {
            border-bottom: none;
        }

        .user-cell {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--medium-gray);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary-blue);
        }

        .user-name {
            font-weight: 500;
            color: var(--text-light);
        }

        .date-cell {
            color: var(--text-dim);
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .empty-state {
            text-align: center;
            padding: 2rem 1rem;
            color: var(--text-dim);
        }

        .empty-state-icon {
            font-size: 2.5rem;
            color: var(--light-gray);
            margin-bottom: 1rem;
        }

        .empty-state-text {
            font-size: 1rem;
        }

        /* Copy notification */
        .copy-notification {
            position: fixed;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            background-color: var(--primary-blue);
            color: var(--black);
            padding: 12px 24px;
            border-radius: 8px;
            z-index: 9999;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.5s, visibility 0.5s;
            font-weight: 600;
        }

        .copy-notification.show {
            opacity: 1;
            visibility: visible;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .header {
                padding: 0.75rem 1rem;
            }
            
            .logo-text {
                font-size: 1.2rem;
            }
            
            .account-info {
                display: none;
            }
            
            .right-sidebar {
                width: 80%; /* 80% width on mobile instead of 50% */
                right: -80%;
            }
            
            .stats-container {
                grid-template-columns: 1fr;
            }
            
            .share-buttons {
                flex-direction: column;
            }
            
            .badge-container {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .next-badge {
                margin-top: 0.25rem;
            }
            
            .bottom-nav-text {
                font-size: 0.6rem;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="logo">
            <img src="/g1.jpg" alt="Gainmart Logo">
            <div class="logo-text">Gainmart</div>
        </div>
        <div class="header-actions">
            <div class="account-section">
                <button class="account-btn" id="accountBtn">
                    <img src="/g1.jpg" alt="Profile" class="account-avatar">
                    <div class="account-info">
                        <span class="account-name"><?php echo $fullname ?></span>
                        <span class="account-username">@<?php echo $username ?></span>
                    </div>
                    <i class="fas fa-chevron-down"></i>
                </button>
                
                <div class="account-dropdown" id="accountDropdown">
                    <a href="settings" class="dropdown-item">
                        <i class="fas fa-cog"></i>
                        <span>Settings</span>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="logout" class="dropdown-item">
                        <i class="fas fa-sign-out-alt"></i>
                        <span>Log Out</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Right Sidebar Menu -->
    <div class="right-sidebar" id="rightSidebar">
        <div class="sidebar-header">
            <img src="favicon.png" alt="Logo" class="sidebar-logo">
            <button class="sidebar-close" id="sidebarClose">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="sidebar-content">
            <div class="nk-sidebar-menu" data-simplebar>
                <ul class="nk-menu">
                    <li class="nk-menu-item">
                        <a href="../user/index" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-home"></i></span>
                            <span class="nk-menu-text">Dashboard</span>
                        </a>
                    </li>
                    <li class="nk-menu-item">
                        <a href="user_packages.php" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-box"></i></span>
                            <span class="nk-menu-text">Investment Packages</span>
                        </a>
                    </li>
                    <li class="nk-menu-item">
                        <a href="user_withdrawal.php" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-money-bill-wave"></i></span>
                            <span class="nk-menu-text">Withdraw Funds</span>
                        </a>
                    </li>
                    <li class="nk-menu-item">
                        <a href="referrals" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-users"></i></span>
                            <span class="nk-menu-text">My Referrals</span>
                        </a>
                    </li>
                    <li class="nk-menu-item">
                        <a href="settings" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-cog"></i></span>
                            <span class="nk-menu-text">Account Settings</span>
                        </a>
                    </li>
                    
                    <div class="mt-5"></div>
                </ul>
            </div>
        </div>
    </div>

    <!-- Sidebar Overlay -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <div class="nk-content px-0">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="row g-gs">

                        <div class="col-12 px-3 mt-4">
                            <h1 class="page-title">My Referrals</h1>
                        </div>

                        <!-- Stats Cards -->
                        <div class="col-12">
                            <div class="stats-container">
                                <div class="stat-card">
                                    <div class="stat-header">
                                        <div class="stat-title">Total Referrals</div>
                                        <div class="stat-icon primary">
                                            <i class="fas fa-users"></i>
                                        </div>
                                    </div>
                                    <div class="stat-value"><?php echo number_format($totalReferrals) ?></div>
                                </div>
                                <div class="stat-card">
                                    <div class="stat-header">
                                        <div class="stat-title">Referral Earnings</div>
                                        <div class="stat-icon success">
                                            <i class="fas fa-coins"></i>
                                        </div>
                                    </div>
                                    <div class="stat-value">₦<?php echo number_format($referralFunds, 2) ?></div>
                                </div>
                            </div>
                        </div>

                        <!-- Referral Link Section -->
                        <div class="col-12">
                            <div class="referral-section">
                                <div class="section-title">
                                    <i class="fas fa-link"></i>
                                    <span>Your Referral Link</span>
                                </div>
                                
                                <p class="referral-description">
                                    Share this link with friends and earn bonuses for each successful referral!
                                </p>
                                
                                <div class="referral-input-group">
                                    <input type="text" class="referral-input" id="refUrl" readonly value="https://gainmart.top/register?ref=<?php echo $username ?>">
                                    <button class="copy-btn" id="copyButton">
                                        <i class="fas fa-copy"></i>
                                        <span>Copy</span>
                                    </button>
                                </div>
                                
                                <div class="share-buttons">
                                    <a href="https://wa.me/?text=Join%20me%20on%20Gainmart%20and%20start%20earning!%20Use%20my%20referral%20link:%20https://gainmart.top/register?ref=<?php echo $username ?>" target="_blank" class="share-btn share-whatsapp">
                                        <i class="fab fa-whatsapp"></i>
                                        <span>WhatsApp</span>
                                    </a>
                                    <a href="https://www.facebook.com/sharer/sharer.php?u=https://gainmart.top/register?ref=<?php echo $username ?>" target="_blank" class="share-btn share-facebook">
                                        <i class="fab fa-facebook-f"></i>
                                        <span>Facebook</span>
                                    </a>
                                    <a href="https://twitter.com/intent/tweet?text=Join%20me%20on%20Gainmart%20and%20start%20earning!%20https://gainmart.top/register?ref=<?php echo $username ?>" target="_blank" class="share-btn share-twitter">
                                        <i class="fab fa-twitter"></i>
                                        <span>Twitter</span>
                                    </a>
                                </div>
                                
                                <!-- Referral Progress Bar -->
                                <div class="referral-progress">
                                    <div class="badge-container">
                                        <div class="current-badge">
                                            <span class="badge-icon">
                                                <i class="fas fa-star"></i>
                                            </span>
                                            <span>Your Badge: <?php echo $referralBadge; ?></span>
                                        </div>
                                        <div class="next-badge">Next: <?php echo $nextBadge; ?></div>
                                    </div>
                                    
                                    <div class="progress-container">
                                        <div class="progress-bar"></div>
                                    </div>
                                    
                                    <div class="progress-text">
                                        <span class="progress-current"><?php echo $totalReferrals; ?> referrals</span>
                                        <span class="progress-max"><?php echo $progressMax; ?> referrals</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Referrals Table -->
                        <div class="col-12">
                            <div class="referrals-table">
                                <div class="section-title">
                                    <i class="fas fa-users"></i>
                                    <span>Your Referrals</span>
                                </div>
                                
                                <div class="table-container">
                                    <?php 
                                    $sql=$link->prepare("SELECT * FROM referrals WHERE referral=? ORDER BY id DESC LIMIT 500");
                                    $sql->bind_param("s", $username);
                                    $sql->execute();
                                    $result=$sql->get_result();                  
                                    $numrow=$result->num_rows;
                                    if($numrow > 0){
                                    ?>
                                        <table class="referral-table">
                                            <thead>
                                                <tr>
                                                    <th>Username</th>
                                                    <th>Registered Date</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php 
                                                while($row=$result->fetch_assoc()){
                                                    $userName=$row['username']; 
                                                    $date=$row['date']; 
                                                ?>
                                                    <tr>
                                                        <td>
                                                            <div class="user-cell">
                                                                <div class="user-avatar">
                                                                    <i class="fas fa-user"></i>
                                                                </div>
                                                                <div class="user-name"><?php echo $userName ?></div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="date-cell">
                                                                <i class="fas fa-calendar-alt"></i>
                                                                <span><?php echo $date ?></span>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php } 
                                                ?>
                                            </tbody>
                                        </table>
                                    <?php } else { ?>
                                        <div class="empty-state">
                                            <div class="empty-state-icon">
                                                <i class="fas fa-user-friends"></i>
                                            </div>
                                            <div class="empty-state-text">No referrals found</div>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bottom Navigation Bar -->
    <div class="bottom-navigation">
        <a href="../user/index" class="bottom-nav-item">
            <i class="fas fa-home bottom-nav-icon"></i>
            <span class="bottom-nav-text">Dashboard</span>
        </a>
        <a href="user_packages.php" class="bottom-nav-item">
            <i class="fas fa-box bottom-nav-icon"></i>
            <span class="bottom-nav-text">Packages</span>
        </a>
        <a href="user_withdrawal.php" class="bottom-nav-item">
            <i class="fas fa-money-bill-wave bottom-nav-icon"></i>
            <span class="bottom-nav-text">Withdraw</span>
        </a>
        <a href="referrals" class="bottom-nav-item active">
            <i class="fas fa-users bottom-nav-icon"></i>
            <span class="bottom-nav-text">Referrals</span>
        </a>
        <a href="settings" class="bottom-nav-item">
            <i class="fas fa-cog bottom-nav-icon"></i>
            <span class="bottom-nav-text">Settings</span>
        </a>
    </div>

    <!-- Copy Notification -->
    <div class="copy-notification" id="copyNotification">
        Referral link copied to clipboard!
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Account dropdown functionality
        const accountBtn = document.getElementById('accountBtn');
        const accountDropdown = document.getElementById('accountDropdown');
        
        if (accountBtn && accountDropdown) {
            accountBtn.addEventListener('click', function(e) {
                e.stopPropagation();
                accountDropdown.classList.toggle('active');
            });
            
            // Close dropdown when clicking outside
            document.addEventListener('click', function() {
                accountDropdown.classList.remove('active');
            });
            
            // Prevent dropdown from closing when clicking inside it
            accountDropdown.addEventListener('click', function(e) {
                e.stopPropagation();
            });
        }
        
        // Right sidebar functionality
        const hamburgerBtn = document.getElementById('hamburgerBtn');
        const rightSidebar = document.getElementById('rightSidebar');
        const sidebarClose = document.getElementById('sidebarClose');
        const sidebarOverlay = document.getElementById('sidebarOverlay');
        
        if (hamburgerBtn && rightSidebar && sidebarClose && sidebarOverlay) {
            // Open sidebar when hamburger is clicked
            hamburgerBtn.addEventListener('click', function() {
                rightSidebar.classList.add('active');
                sidebarOverlay.classList.add('active');
                document.body.style.overflow = 'hidden'; // Prevent body scroll when sidebar is open
                
                // Reset animations when opening
                const menuItems = rightSidebar.querySelectorAll('.nk-menu-item');
                menuItems.forEach(item => {
                    item.style.animation = 'none';
                    item.offsetHeight; // Trigger reflow
                    item.style.animation = null;
                });
            });
            
            // Close sidebar when close button is clicked
            sidebarClose.addEventListener('click', function() {
                rightSidebar.classList.remove('active');
                sidebarOverlay.classList.remove('active');
                document.body.style.overflow = ''; // Restore body scroll
            });
            
            // Close sidebar when overlay is clicked
            sidebarOverlay.addEventListener('click', function() {
                rightSidebar.classList.remove('active');
                sidebarOverlay.classList.remove('active');
                document.body.style.overflow = ''; // Restore body scroll
            });
            
            // Handle submenu toggles
            const menuToggles = document.querySelectorAll('.nk-menu-toggle');
            menuToggles.forEach(toggle => {
                toggle.addEventListener('click', function(e) {
                    e.preventDefault();
                    const parentItem = this.parentElement;
                    const submenu = parentItem.querySelector('.nk-menu-sub');
                    
                    if (submenu) {
                        submenu.classList.toggle('active');
                        this.classList.toggle('active');
                    }
                });
            });
        }
        
        // Copy referral link functionality
        const copyButton = document.getElementById('copyButton');
        const refUrlInput = document.getElementById('refUrl');
        const copyNotification = document.getElementById('copyNotification');
        
        if (copyButton && refUrlInput) {
            copyButton.addEventListener('click', function(e) {
                e.preventDefault(); // Prevent any default behavior
                
                // Get the text to copy
                const textToCopy = refUrlInput.value;
                
                // Create a temporary textarea element
                const tempTextArea = document.createElement('textarea');
                tempTextArea.value = textToCopy;
                
                // Make the textarea invisible
                tempTextArea.style.position = 'fixed';
                tempTextArea.style.top = 0;
                tempTextArea.style.left = 0;
                tempTextArea.style.width = '2em';
                tempTextArea.style.height = '2em';
                tempTextArea.style.padding = 0;
                tempTextArea.style.border = 'none';
                tempTextArea.style.outline = 'none';
                tempTextArea.style.boxShadow = 'none';
                tempTextArea.style.background = 'transparent';
                tempTextArea.style.opacity = 0;
                
                // Add the textarea to the document
                document.body.appendChild(tempTextArea);
                
                // Select the text
                tempTextArea.select();
                
                try {
                    // Execute the copy command
                    const successful = document.execCommand('copy');
                    
                    // Remove the temporary textarea
                    document.body.removeChild(tempTextArea);
                    
                    if (successful) {
                        // Change button text temporarily
                        const originalHTML = copyButton.innerHTML;
                        copyButton.innerHTML = '<i class="fas fa-check"></i><span>Copied!</span>';
                        
                        // Show notification
                        copyNotification.classList.add('show');
                        
                        // Reset button after 2 seconds
                        setTimeout(function() {
                            copyButton.innerHTML = originalHTML;
                        }, 2000);
                        
                        // Hide notification after 3 seconds
                        setTimeout(function() {
                            copyNotification.classList.remove('show');
                        }, 3000);
                    } else {
                        console.error('Unable to copy');
                        // Fallback for browsers that don't support execCommand
                        alert('Please copy the link manually: ' + textToCopy);
                    }
                } catch (err) {
                    console.error('Failed to copy text: ', err);
                    // Remove the temporary textarea
                    document.body.removeChild(tempTextArea);
                    // Fallback for browsers that don't support execCommand
                    alert('Please copy the link manually: ' + textToCopy);
                }
                
                return false; // Prevent any further propagation
            });
        }
    });
    </script>
</body>
</html>