<?php
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/actions/profile.php";
$ptitle = "Security Settings";
include "includes/header.php";
?>

<style>
    :root {
        --primary-red: #ff3131;
        --dark-red: #cc0000;
        --black: #000000;
        --white: #ffffff;
        --light-gray: #f8f9fa;
        --medium-gray: #e9ecef;
    }
    
    body {
        background-color: var(--white);
        color: var(--black);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    .nk-content {
        padding: 1.5rem 0;
        background-color: var(--light-gray);
    }
    
    .profile-header {
        background: linear-gradient(135deg, var(--primary-red) 0%, var(--dark-red) 100%);
        color: var(--white);
        border-radius: 12px;
        padding: 2rem;
        margin-bottom: 2rem;
        box-shadow: 0 4px 12px rgba(255, 49, 49, 0.3);
    }
    
    .profile-header h3 {
        font-weight: 700;
        margin-bottom: 0.5rem;
    }
    
    .profile-header .small {
        opacity: 0.9;
    }
    
    .profile-img {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        border: 4px solid var(--white);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    
    .card {
        border: none;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        margin-bottom: 1.5rem;
        overflow: hidden;
        background-color: var(--white);
    }
    
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
    }
    
    .card-body {
        padding: 1.5rem;
    }
    
    .card-title {
        color: var(--black);
        font-weight: 600;
        margin-bottom: 1.5rem;
        padding-bottom: 0.75rem;
        border-bottom: 2px solid var(--light-gray);
    }
    
    .form-label {
        color: var(--black);
        font-weight: 600;
        margin-bottom: 0.5rem;
    }
    
    .form-control {
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        padding: 0.75rem 1rem;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: var(--white);
    }
    
    .form-control:focus {
        border-color: var(--primary-red);
        box-shadow: 0 0 0 0.2rem rgba(255, 49, 49, 0.25);
    }
    
    .btn-primary {
        background-color: var(--primary-red);
        border: none;
        border-radius: 8px;
        padding: 0.75rem 1.5rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.3s ease;
        color: var(--white);
    }
    
    .btn-primary:hover {
        background-color: var(--dark-red);
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(255, 49, 49, 0.4);
    }
    
    .nav-pills .nav-link {
        color: var(--black);
        border-radius: 8px;
        padding: 0.75rem 1.5rem;
        font-weight: 500;
        margin-right: 0.5rem;
        transition: all 0.3s ease;
    }
    
    .nav-pills .nav-link.active {
        background-color: var(--primary-red);
        color: var(--white);
    }
    
    .nav-pills .nav-link:hover {
        background-color: rgba(255, 49, 49, 0.1);
        color: var(--primary-red);
    }
    
    .response {
        margin-bottom: 1.5rem;
    }
    
    .settings-nav {
        background-color: var(--white);
        border-radius: 12px;
        padding: 1rem;
        margin-bottom: 2rem;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }
    
    .settings-nav .nav-link {
        display: flex;
        align-items: center;
        padding: 0.75rem 1rem;
        border-radius: 8px;
        color: var(--black);
        transition: all 0.3s ease;
    }
    
    .settings-nav .nav-link.active {
        background-color: rgba(255, 49, 49, 0.1);
        color: var(--primary-red);
        font-weight: 600;
    }
    
    .settings-nav .nav-link:hover {
        background-color: rgba(255, 49, 49, 0.05);
    }
    
    .settings-nav .nav-link i {
        margin-right: 0.75rem;
        color: var(--primary-red);
    }
    
    .security-icon {
        font-size: 3rem;
        color: var(--primary-red);
        margin-bottom: 1rem;
    }
    
    .password-toggle {
        position: absolute;
        right: 10px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        color: var(--medium-gray);
    }
    
    .password-toggle:hover {
        color: var(--primary-red);
    }
    
    .form-control-wrap {
        position: relative;
    }
    
    .info-box {
        background-color: rgba(255, 49, 49, 0.05);
        border-left: 4px solid var(--primary-red);
        padding: 1rem;
        border-radius: 0 8px 8px 0;
        margin-bottom: 1.5rem;
    }
    
    .info-box h5 {
        color: var(--primary-red);
        font-weight: 600;
        margin-bottom: 0.5rem;
    }
    
    .security-tips {
        background-color: var(--light-gray);
        border-radius: 8px;
        padding: 1rem;
        margin-top: 1.5rem;
    }
    
    .security-tips h5 {
        color: var(--black);
        font-weight: 600;
        margin-bottom: 0.75rem;
    }
    
    .security-tips ul {
        padding-left: 1.5rem;
        margin-bottom: 0;
    }
    
    .security-tips li {
        margin-bottom: 0.5rem;
    }
    
    @media (max-width: 768px) {
        .profile-header {
            padding: 1.5rem;
        }
        
        .profile-img {
            width: 80px;
            height: 80px;
        }
        
        .card-body {
            padding: 1.25rem;
        }
    }
</style>

<div class="nk-content px-0">
    <div class="container">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="profile-header">
                    <div class="d-flex flex-column flex-md-row align-items-md-center">
                        <div class="media media-huge media-circle">
                            <img src="../favicon.png" class="profile-img" alt="Profile">
                        </div>
                        <div class="mt-3 mt-md-0 ms-md-3">
                            <h3 class="title mb-1"><?php echo $fullname ?></h3>
                            <span class="small"><?php echo $username ?></span>
                        </div>
                    </div>
                </div>
                
                <div class="settings-nav">
                    <div class="row">
                        <div class="col-12">
                            <ul class="nav nav-pills">
                                <li class="nav-item">
                                    <a class="nav-link" href="account.php">
                                        <em class="icon ni ni-user"></em> Account
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="bank.php">
                                        <em class="icon ni ni-credit-card"></em> Bank
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link active" href="security.php">
                                        <em class="icon ni ni-lock-alt"></em> Security
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="nk-block">
                    <div class="response"><?php echo $genMsg ?></div>
                    
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">
                                <em class="icon ni ni-lock-alt me-2"></em> Change Password
                            </h4>
                            
                            <div class="info-box">
                                <h5>Password Security</h5>
                                <p>For your account security, we recommend using a strong password that you don't use elsewhere.</p>
                            </div>
                            
                            <form method="POST">
                                <div class="row g-3">
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for="currPsw" class="form-label">Old Password</label>
                                            <div class="form-control-wrap">
                                                <a class="form-control-icon end password-toggle" title="Toggle show/hide password">
                                                    <em class="on icon ni ni-eye-off"></em>
                                                    <em class="off icon ni ni-eye"></em>
                                                </a>
                                                <input type="password" class="form-control" name="currPsw" placeholder="Old password">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for="newPsw" class="form-label">New Password</label>
                                            <div class="form-control-wrap">
                                                <a class="form-control-icon end password-toggle" title="Toggle show/hide password">
                                                    <em class="on icon ni ni-eye-off"></em>
                                                    <em class="off icon ni ni-eye"></em>
                                                </a>
                                                <input type="password" class="form-control" name="newPsw" placeholder="New password">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for="confirmPsw" class="form-label">Confirm New Password</label>
                                            <div class="form-control-wrap">
                                                <a class="form-control-icon end password-toggle" title="Toggle show/hide password">
                                                    <em class="on icon ni ni-eye-off"></em>
                                                    <em class="off icon ni ni-eye"></em>
                                                </a>
                                                <input type="password" class="form-control" name="confirmPsw" placeholder="Confirm New Password">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="d-flex flex-wrap align-items-center gap g-3">
                                            <div class="gap-col">
                                                <button class="btn btn-primary" name="updatePsw" type="submit">Change Password</button>
                                            </div>
                                            <div class="gap-col">
                                                <a href="../forgot-password" class="text-primary small" target="_blank">Forgot Password?</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            
                            <div class="security-tips">
                                <h5>Password Security Tips</h5>
                                <ul>
                                    <li>Use a strong password with at least 8 characters</li>
                                    <li>Include a mix of uppercase, lowercase, numbers, and symbols</li>
                                    <li>Avoid using personal information like your name or birthdate</li>
                                    <li>Don't reuse passwords across different websites</li>
                                    <li>Change your password regularly</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Password toggle functionality
        const passwordToggles = document.querySelectorAll('.password-toggle');
        
        passwordToggles.forEach(toggle => {
            toggle.addEventListener('click', function() {
                const input = this.parentElement.querySelector('input');
                const iconOn = this.querySelector('.on');
                const iconOff = this.querySelector('.off');
                
                if (input.type === 'password') {
                    input.type = 'text';
                    iconOn.style.display = 'none';
                    iconOff.style.display = 'inline-block';
                } else {
                    input.type = 'password';
                    iconOn.style.display = 'inline-block';
                    iconOff.style.display = 'none';
                }
            });
        });
    });
</script>

<?php include "includes/footer.php"; ?>