<?php
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/includes/generalinclude.php";

$ptitle = "Spin & Win";
include "includes/header.php";

// Game configuration
$baseAmount = 10; // Base amount to multiply
$maxSpins = 10; // Maximum spins per user
$multipliers = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]; // Possible multipliers

// Initialize user spins if not set
if (!isset($_SESSION['spins_remaining'])) {
    $_SESSION['spins_remaining'] = $maxSpins;
}

// Handle spin submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['spin'])) {
    if ($_SESSION['spins_remaining'] > 0) {
        // Get random multiplier
        $multiplier = $multipliers[array_rand($multipliers)];
        $winnings = $baseAmount * $multiplier;
        
        // Add to user funds
        $updateSql = $link->prepare("UPDATE users SET funds = funds + ? WHERE username = ?");
        $updateSql->bind_param("ds", $winnings, $username);
        $updateSql->execute();
        
        // Decrement spin count
        $_SESSION['spins_remaining']--;
        
        // Show success message
        $successMsg = "Congratulations! You won ₦" . number_format($winnings, 2) . " ({$multiplier}x multiplier)!";
    } else {
        $errorMsg = "You've used all your spins for today!";
    }
}
?>

<style>
    :root {
        --primary-red: #ff3131;
        --dark-red: #cc0000;
        --black: #000000;
        --white: #ffffff;
        --light-gray: #f8f9fa;
        --medium-gray: #e9ecef;
    }
    
    body {
        background-color: var(--white);
        color: var(--black);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    .nk-content {
        padding: 1.5rem 0;
        background-color: var(--light-gray);
        min-height: 80vh;
        display: flex;
        align-items: center;
    }
    
    .container {
        max-width: 800px;
    }
    
    .wheel-container {
        position: relative;
        width: 300px;
        height: 300px;
        margin: 0 auto 2rem;
    }
    
    .wheel {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        position: relative;
        overflow: hidden;
        border: 8px solid var(--dark-red);
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
    }
    
    .wheel-segment {
        position: absolute;
        width: 50%;
        height: 50%;
        transform-origin: right bottom;
    }
    
    .wheel-segment:nth-child(1) { background: #ff3131; transform: rotate(0deg); }
    .wheel-segment:nth-child(2) { background: #ff6b6b; transform: rotate(36deg); }
    .wheel-segment:nth-child(3) { background: #ff9e9e; transform: rotate(72deg); }
    .wheel-segment:nth-child(4) { background: #ffd166; transform: rotate(108deg); }
    .wheel-segment:nth-child(5) { background: #ffd93d; transform: rotate(144deg); }
    .wheel-segment:nth-child(6) { background: #6bcf7f; transform: rotate(180deg); }
    .wheel-segment:nth-child(7) { background: #4d96ff; transform: rotate(216deg); }
    .wheel-segment:nth-child(8) { background: #6c5ce7; transform: rotate(252deg); }
    .wheel-segment:nth-child(9) { background: #a29bfe; transform: rotate(288deg); }
    .wheel-segment:nth-child(10) { background: #fd79a8; transform: rotate(324deg); }
    
    .wheel-text {
        position: absolute;
        top: 20%;
        left: 50%;
        transform: translateX(-50%);
        font-weight: bold;
        color: white;
        text-shadow: 1px 1px 2px rgba(0,0,0,0.5);
    }
    
    .wheel-center {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 40px;
        height: 40px;
        background: var(--dark-red);
        border-radius: 50%;
        z-index: 10;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: bold;
    }
    
    .wheel-pointer {
        position: absolute;
        top: -15px;
        left: 50%;
        transform: translateX(-50%);
        width: 0;
        height: 0;
        border-left: 15px solid transparent;
        border-right: 15px solid transparent;
        border-top: 30px solid var(--dark-red);
        z-index: 5;
    }
    
    .spin-button {
        display: block;
        width: 200px;
        margin: 0 auto;
        padding: 12px 24px;
        background: var(--primary-red);
        color: white;
        border: none;
        border-radius: 30px;
        font-size: 1.2rem;
        font-weight: bold;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .spin-button:hover {
        background: var(--dark-red);
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(255, 49, 49, 0.4);
    }
    
    .spin-button:disabled {
        background: #cccccc;
        cursor: not-allowed;
        transform: none;
        box-shadow: none;
    }
    
    .game-info {
        text-align: center;
        margin-bottom: 2rem;
    }
    
    .game-info h2 {
        color: var(--black);
        margin-bottom: 1rem;
    }
    
    .spins-remaining {
        font-size: 1.2rem;
        font-weight: bold;
        color: var(--primary-red);
        margin-bottom: 1rem;
    }
    
    .message {
        padding: 15px;
        border-radius: 8px;
        margin: 1.5rem 0;
        text-align: center;
        font-weight: bold;
    }
    
    .success-message {
        background-color: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
    }
    
    .error-message {
        background-color: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
    }
    
    .multiplier-legend {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 10px;
        margin-top: 2rem;
    }
    
    .multiplier-item {
        display: flex;
        align-items: center;
        gap: 5px;
    }
    
    .multiplier-color {
        width: 20px;
        height: 20px;
        border-radius: 4px;
    }
    
    @media (max-width: 768px) {
        .wheel-container {
            width: 250px;
            height: 250px;
        }
        
        .spin-button {
            width: 180px;
            padding: 10px 20px;
            font-size: 1.1rem;
        }
    }
</style>

<div class="nk-content">
    <div class="container">
        <div class="game-info">
            <h2>Spin & Win</h2>
            <p>Test your luck and win up to 10x your base amount!</p>
            <div class="spins-remaining">
                Spins Remaining: <?php echo $_SESSION['spins_remaining']; ?>/<?php echo $maxSpins; ?>
            </div>
        </div>
        
        <?php if (isset($successMsg)): ?>
            <div class="message success-message">
                <?php echo $successMsg; ?>
            </div>
        <?php endif; ?>
        
        <?php if (isset($errorMsg)): ?>
            <div class="message error-message">
                <?php echo $errorMsg; ?>
            </div>
        <?php endif; ?>
        
        <div class="wheel-container">
            <div class="wheel-pointer"></div>
            <div class="wheel">
                <div class="wheel-segment">
                    <div class="wheel-text">1x</div>
                </div>
                <div class="wheel-segment">
                    <div class="wheel-text">2x</div>
                </div>
                <div class="wheel-segment">
                    <div class="wheel-text">3x</div>
                </div>
                <div class="wheel-segment">
                    <div class="wheel-text">4x</div>
                </div>
                <div class="wheel-segment">
                    <div class="wheel-text">5x</div>
                </div>
                <div class="wheel-segment">
                    <div class="wheel-text">6x</div>
                </div>
                <div class="wheel-segment">
                    <div class="wheel-text">7x</div>
                </div>
                <div class="wheel-segment">
                    <div class="wheel-text">8x</div>
                </div>
                <div class="wheel-segment">
                    <div class="wheel-text">9x</div>
                </div>
                <div class="wheel-segment">
                    <div class="wheel-text">10x</div>
                </div>
                <div class="wheel-center">SPIN</div>
            </div>
        </div>
        
        <form method="POST">
            <button type="submit" name="spin" class="spin-button" <?php echo $_SESSION['spins_remaining'] <= 0 ? 'disabled' : ''; ?>>
                <?php echo $_SESSION['spins_remaining'] > 0 ? 'SPIN NOW' : 'NO SPINS LEFT'; ?>
            </button>
        </form>
        
        <div class="multiplier-legend">
            <div class="multiplier-item">
                <div class="multiplier-color" style="background: #ff3131;"></div>
                <span>1x</span>
            </div>
            <div class="multiplier-item">
                <div class="multiplier-color" style="background: #ff6b6b;"></div>
                <span>2x</span>
            </div>
            <div class="multiplier-item">
                <div class="multiplier-color" style="background: #ff9e9e;"></div>
                <span>3x</span>
            </div>
            <div class="multiplier-item">
                <div class="multiplier-color" style="background: #ffd166;"></div>
                <span>4x</span>
            </div>
            <div class="multiplier-item">
                <div class="multiplier-color" style="background: #ffd93d;"></div>
                <span>5x</span>
            </div>
            <div class="multiplier-item">
                <div class="multiplier-color" style="background: #6bcf7f;"></div>
                <span>6x</span>
            </div>
            <div class="multiplier-item">
                <div class="multiplier-color" style="background: #4d96ff;"></div>
                <span>7x</span>
            </div>
            <div class="multiplier-item">
                <div class="multiplier-color" style="background: #6c5ce7;"></div>
                <span>8x</span>
            </div>
            <div class="multiplier-item">
                <div class="multiplier-color" style="background: #a29bfe;"></div>
                <span>9x</span>
            </div>
            <div class="multiplier-item">
                <div class="multiplier-color" style="background: #fd79a8;"></div>
                <span>10x</span>
            </div>
        </div>
    </div>
</div>

<?php include "includes/footer.php"; ?>