<?php
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/actions/sp-posts.php";
$ptitle = "Advert Post";
include "includes/header.php"
?>
<style>
    :root {
        --primary-red: #ff3131;
        --dark-red: #cc0000;
        --black: #000000;
        --white: #ffffff;
        --light-gray: #f8f9fa;
        --medium-gray: #e9ecef;
    }
    
    body {
        background-color: var(--light-gray);
        color: var(--black);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    .nk-content {
        padding: 1.5rem 0;
    }
    
    .nk-block-head {
        margin-bottom: 2rem;
    }
    
    .nk-block-title {
        color: var(--black);
        font-weight: 700;
        font-size: 1.75rem;
        margin-bottom: 0.5rem;
    }
    
    .breadcrumb {
        background-color: transparent;
        padding: 0;
        margin: 0;
    }
    
    .breadcrumb-item a {
        color: var(--primary-red);
        text-decoration: none;
        font-weight: 500;
    }
    
    .breadcrumb-item a:hover {
        color: var(--dark-red);
        text-decoration: underline;
    }
    
    .breadcrumb-item.active a {
        color: var(--black);
    }
    
    .card {
        border: none;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        margin-bottom: 1.5rem;
        overflow: hidden;
        background-color: var(--white);
    }
    
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
    }
    
    .card-body {
        padding: 1.5rem;
    }
    
    .card-title {
        color: var(--black);
        font-weight: 700;
        margin-bottom: 1rem;
    }
    
    .card-text {
        color: var(--black);
        margin-bottom: 1rem;
    }
    
    .card-img-top {
        border-radius: 12px 12px 0 0;
        height: 300px;
        object-fit: cover;
    }
    
    .btn {
        border-radius: 8px;
        padding: 0.6rem 1.2rem;
        font-weight: 600;
        transition: all 0.3s ease;
        margin-right: 0.5rem;
        margin-bottom: 0.5rem;
    }
    
    .btn-light {
        background-color: var(--white);
        color: var(--primary-red);
        border: 1px solid var(--primary-red);
    }
    
    .btn-light:hover {
        background-color: var(--primary-red);
        color: var(--white);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(255, 49, 49, 0.4);
    }
    
    .btn-success {
        background-color: #28a745;
        border: none;
        color: var(--white);
    }
    
    .btn-success:hover {
        background-color: #218838;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(40, 167, 69, 0.4);
    }
    
    .bg-primary {
        background: linear-gradient(135deg, var(--primary-red) 0%, var(--dark-red) 100%) !important;
        color: var(--white) !important;
    }
    
    .text-muted {
        color: var(--medium-gray) !important;
    }
    
    .instruction-box {
        background-color: var(--white);
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        padding: 1.5rem;
        margin-bottom: 2rem;
        border-left: 4px solid var(--primary-red);
    }
    
    .instruction-title {
        color: var(--primary-red);
        font-weight: 700;
        font-size: 1.2rem;
        margin-top: 0;
        margin-bottom: 1rem;
    }
    
    .instruction-step {
        display: flex;
        align-items: flex-start;
        margin-bottom: 1rem;
    }
    
    .step-number {
        background-color: var(--primary-red);
        color: var(--white);
        width: 28px;
        height: 28px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        margin-right: 1rem;
        flex-shrink: 0;
    }
    
    .step-content {
        flex-grow: 1;
    }
    
    .highlight {
        background-color: rgba(255, 49, 49, 0.1);
        color: var(--primary-red);
        padding: 0.2rem 0.5rem;
        border-radius: 4px;
        font-weight: 600;
    }
    
    .genMsg {
        margin-bottom: 1.5rem;
    }
    
    .alert {
        border: none;
        border-radius: 12px;
        padding: 1rem 1.5rem;
    }
    
    .alert-success {
        background-color: rgba(40, 167, 69, 0.1);
        color: #28a745;
    }
    
    .alert-danger {
        background-color: rgba(220, 53, 69, 0.1);
        color: #dc3545;
    }
    
    .alert-info {
        background-color: rgba(23, 162, 184, 0.1);
        color: #17a2b8;
    }
    
    @media (max-width: 768px) {
        .nk-content {
            padding: 1rem 0;
        }
        
        .card-body {
            padding: 1.25rem;
        }
        
        .card-img-top {
            height: 200px;
        }
        
        .btn {
            margin-right: 0;
            margin-bottom: 0.5rem;
            width: 100%;
        }
        
        .instruction-step {
            flex-direction: column;
        }
        
        .step-number {
            margin-right: 0;
            margin-bottom: 0.5rem;
        }
    }
</style>

<div class="nk-content">
    <div class="container">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head">
                    <div class="nk-block-head-between flex-wrap gap g-2">
                        <div class="nk-block-head-content">
                            <h2 class="nk-block-title"><?php echo $ptitle ?></h2>
                            <nav>
                                <ol class="breadcrumb breadcrumb-arrow mb-0">
                                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                                    <li class="breadcrumb-item active"><a href="#"><?php echo $ptitle ?></a></li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
                
                <div class="instruction-box">
                    <h3 class="instruction-title">How to Share Advert Post</h3>
                    
                    <div class="instruction-step">
                        <div class="step-number">1</div>
                        <div class="step-content">
                            Click the <span class="highlight">Download Image</span> button to download the image to your device.
                        </div>
                    </div>
                    
                    <div class="instruction-step">
                        <div class="step-number">2</div>
                        <div class="step-content">
                            Click the <span class="highlight">Copy Text</span> button to copy the text to your clipboard.
                        </div>
                    </div>
                    
                    <div class="instruction-step">
                        <div class="step-number">3</div>
                        <div class="step-content">
                            Click the <span class="highlight">Share Now</span> button to be redirected to the provided Facebook group.
                        </div>
                    </div>
                    
                    <div class="instruction-step">
                        <div class="step-number">4</div>
                        <div class="step-content">
                            Upload the image and paste the text, tag at least 15 friends, and post it.
                        </div>
                    </div>
                    
                    <div class="instruction-step">
                        <div class="step-number">5</div>
                        <div class="step-content">
                            Come back and click the <span class="highlight">Earn Reward</span> button to receive your credit.
                        </div>
                    </div>
                </div>
                
                <div class="genMsg mt-5"><?php echo $addMsg ?></div>
                
                <div class="nk-block row g-4">
                    <?php if ($numrow_task > 0 & $numrow_userTask == 0) { ?>
                        <div class="col-sm-12 col-lg-12 mb-4">
                            <div class="card">
                                <img class="card-img-top" src="assets/images/sponsoredposts/<?php echo $image ?>" alt="Card image cap" />
                                <div class="card-body">
                                    <h5 class="card-title"><?php echo $title ?></h5>
                                    <p class="card-text" id="input-text"><?php echo $desc ?></p>
                                    <p class="card-text"><small class="text-muted"><?php echo $date ?></small></p>
                                </div>
                            </div>
                        </div>
                        <?php
                        $encodedDesc = json_encode($desc, JSON_HEX_QUOT | JSON_HEX_TAG);
                        ?>
                        <div class="col-md-6 col-xl-4">
                            <div class="card bg-primary text-white mb-3">
                                <div class="card-body">
                                    <h5 class="card-title mb-3">Actions</h5>
                                    <p class="card-text"><strong>Note:</strong> Make sure you download the image and copy the text to post on your social media. Failure to do this will result in no payment.</p>
                                    <div class="d-flex flex-wrap">
                                        <button class="btn btn-light" id="copy-button">
                                            <em class="icon ni ni-copy me-1"></em> Copy text
                                        </button>
                                        <a href="assets/images/sponsoredposts/<?php echo $image ?>" class="btn btn-light" download>
                                            <em class="icon ni ni-download me-1"></em> Download image
                                        </a>
                                        <a class="btn btn-light" href="<?php echo $postUrl ?>">
                                            <em class="icon ni ni-external me-1"></em> Visit Link
                                        </a>
                                        <?php if($shareToWhatsapp){ ?>
                                        <button class="btn btn-success" id="shareWhatsapp">
                                            <em class="icon ni ni-whatsapp me-1"></em> Share to Whatsapp
                                        </button>
                                        <?php } ?>
                                        <button class="btn btn-light acceptTask">
                                            <em class="icon ni ni-coins me-1"></em> Earn Reward
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <script>
                            const shareWhatsapp = document.getElementById('shareWhatsapp');
                            if (shareWhatsapp) {
                                shareWhatsapp.addEventListener('click', () => {
                                    const message = <?php echo $encodedDesc ?>;
                                    const whatsappUrl = `whatsapp://send?text=${encodeURIComponent(message)}`;
                                    window.location.href = whatsappUrl;
                                    console.log('Opened WhatsApp using URL scheme');
                                });
                            }
                        </script>
                        
                    <?php } else if ($numrow_userTask > 0) { ?>
                        <div class="col-md-6 col-xl-4">
                            <div class="card bg-primary text-white mb-3">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <em class="icon ni ni-check-circle-fill me-3" style="font-size: 2rem;"></em>
                                        <div>
                                            <h5 class="card-title mb-1">Task Completed</h5>
                                            <p class="card-text mb-0">You have completed today's Advert task.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                        <div class="col-md-6 col-xl-4">
                            <div class="card bg-primary text-white mb-3">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <em class="icon ni ni-clock me-3" style="font-size: 2rem;"></em>
                                        <div>
                                            <h5 class="card-title mb-1">No Task Available</h5>
                                            <p class="card-text mb-0">Today's Advert task is not yet available.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="sweetalert.js"></script>
<script src="addtasks.js"></script>
<script src="https://cdn.jsdelivr.net/npm/clipboard@2/dist/clipboard.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        var clipboard = new ClipboardJS('#copy-button', {
            target: function() {
                return document.getElementById('input-text');
            }
        });
        
        clipboard.on('success', function(e) {
            Swal.fire({
                title: "Success!",
                text: "Advert post text has been copied to your clipboard.",
                icon: "success",
                timer: 2000,
                showConfirmButton: false
            });
        });
        
        clipboard.on('error', function(e) {
            Swal.fire({
                title: "Error!",
                text: "An error occurred while trying to copy the text.",
                icon: "error",
                timer: 2000,
                showConfirmButton: false
            });
        });
    });
</script>

<?php include "includes/footer.php" ?>