<?php
// Start session at the very top before any output
session_start();

// Initialize variables
$ptitle = "Daily Tasks";
$username = $_SESSION['username'] ?? '';
$role = $_SESSION['role'] ?? '';

// Now include other files
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/user/includes/generalinclude.php";

// Set the timezone explicitly
date_default_timezone_set('UTC');

// Check if claimed_tasks table exists, create if not
$tableCheck = $link->query("SHOW TABLES LIKE 'claimed_tasks'");
if ($tableCheck->num_rows == 0) {
    $createTable = "CREATE TABLE `claimed_tasks` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `username` varchar(255) NOT NULL,
        `task_id` int(11) NOT NULL,
        `claimed_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        UNIQUE KEY `user_task` (`username`, `task_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    if ($link->query($createTable)) {
        $taskMsg = '<div class="alert alert-info">Claimed tasks table created successfully!</div>';
    } else {
        die("Error creating claimed_tasks table: " . $link->error);
    }
}

// Handle task claim
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['claimTask'])) {
    $taskId = $_POST['taskId'];
    
    // Check if user already claimed the task
    $check = $link->prepare("SELECT * FROM claimed_tasks WHERE username=? AND task_id=?");
    $check->bind_param("si", $username, $taskId);
    $check->execute();
    $result = $check->get_result();
    
    if ($result->num_rows > 0) {
        $taskMsg = '<div class="alert alert-warning">You have already claimed this task.</div>';
    } else {
        // Get task details
        $query = $link->prepare("SELECT amount FROM tasks WHERE id=?");
        $query->bind_param("i", $taskId);
        $query->execute();
        $taskData = $query->get_result();
        
        if ($taskData->num_rows > 0) {
            $task = $taskData->fetch_assoc();
            $amount = floatval($task['amount']);
            
            // Update user funds
            $update = $link->prepare("UPDATE users SET funds = funds + ? WHERE username=?");
            $update->bind_param("ds", $amount, $username);
            $update->execute();
            
            // Insert into claimed tasks
            $insert = $link->prepare("INSERT INTO claimed_tasks (username, task_id) VALUES (?, ?)");
            $insert->bind_param("si", $username, $taskId);
            $insert->execute();
            
            $taskMsg = '<div class="alert alert-success">Task claimed! ₦' . number_format($amount, 2) . ' has been added to your wallet.</div>';
        }
    }
}

// Get current date and time
$currentDate = date('Y-m-d H:i:s');

// Get available tasks (active, not expired, not claimed by user)
$sql = $link->prepare("
    SELECT t.* 
    FROM tasks t 
    LEFT JOIN claimed_tasks c ON t.id = c.task_id AND c.username = ? 
    WHERE t.status = 1 
    AND (t.expiration_date IS NULL OR t.expiration_date > ?) 
    AND c.task_id IS NULL 
    ORDER BY t.id DESC
");
$sql->bind_param("ss", $username, $currentDate);
$sql->execute();
$result = $sql->get_result();
$numrow = $result->num_rows;

// Get completed tasks
$completedSql = $link->prepare("
    SELECT t.*, c.claimed_at 
    FROM tasks t 
    JOIN claimed_tasks c ON t.id = c.task_id 
    WHERE c.username = ? 
    ORDER BY c.claimed_at DESC 
    LIMIT 10
");
$completedSql->bind_param("s", $username);
$completedSql->execute();
$completedResult = $completedSql->get_result();

// Now include header after session is properly initialized
include "includes/header.php";
?>

<style>
  :root {
    --primary-color: #e63946;
    --primary-dark: #d62828;
    --primary-light: #ffcccc;
    --text-color: #000000;
    --bg-color: #ffffff;
    --card-bg: #ffffff;
    --card-border: #e63946;
    --shadow: rgba(0, 0, 0, 0.1);
    --card-radius: 12px;
    --transition: all 0.3s ease;
  }

  body {
    position: relative;
    margin: 0;
    padding: 0;
    overflow-x: hidden;
    color: var(--text-color);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background-color: var(--bg-color);
  }

  body::before {
    content: "";
    background: url('/gbg.jpg') no-repeat center center fixed;
    background-size: cover;
    position: fixed;
    top: 0;
    left: 0;
    width: 100vw;
    height: 100vh;
    z-index: -1;
    filter: blur(3px);
    opacity: 0.05;
  }

  .nk-content {
    padding: 2rem 0;
  }

  .nk-block-head {
    margin-bottom: 2.5rem;
  }

  .nk-block-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--text-color);
    margin-bottom: 0.5rem;
  }

  .breadcrumb {
    background-color: rgba(230, 57, 70, 0.1);
    border-radius: 8px;
    padding: 0.75rem 1rem;
  }

  .breadcrumb-item a {
    color: var(--primary-color);
    text-decoration: none;
    font-weight: 500;
    transition: var(--transition);
  }

  .breadcrumb-item a:hover {
    color: var(--primary-dark);
  }

  .breadcrumb-item.active a {
    color: var(--text-color);
  }

  .alert {
    border-radius: 8px;
    padding: 1rem 1.5rem;
    margin-bottom: 1.5rem;
    border: none;
    box-shadow: 0 4px 12px var(--shadow);
    font-weight: 500;
  }

  .alert-success {
    background-color: rgba(40, 167, 69, 0.1);
    color: #28a745;
    border-left: 4px solid #28a745;
  }

  .alert-warning {
    background-color: rgba(255, 193, 7, 0.1);
    color: #ffc107;
    border-left: 4px solid #ffc107;
  }

  .alert-info {
    background-color: rgba(23, 162, 184, 0.1);
    color: #17a2b8;
    border-left: 4px solid #17a2b8;
  }

  .tasks-container {
    width: 100%;
    margin: 30px 0;
    padding: 0 15px;
  }

  .tasks-container h3 {
    font-size: 1.8rem;
    font-weight: 600;
    color: var(--text-color);
    margin-bottom: 1.5rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid var(--primary-color);
    display: inline-block;
  }

  .tasks-container h3 small {
    font-weight: 400;
    font-size: 0.9em;
    color: var(--primary-color);
  }

  .tasks-row {
    display: flex;
    flex-wrap: wrap;
    gap: 25px;
    margin-bottom: 40px;
  }

  .task-card {
    flex: 0 0 calc(25% - 25px);
    background-color: var(--card-bg);
    color: var(--text-color);
    border-radius: var(--card-radius);
    box-shadow: 0 5px 15px var(--shadow);
    padding: 25px;
    border: 2px solid var(--card-border);
    transition: var(--transition);
    position: relative;
    overflow: hidden;
    display: flex;
    flex-direction: column;
  }

  .task-card::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 5px;
    height: 100%;
    background-color: var(--primary-color);
    z-index: 1;
  }

  .task-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px var(--shadow);
    border-color: var(--primary-dark);
  }

  .task-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 20px;
    position: relative;
    z-index: 2;
  }

  .task-title {
    font-weight: 700;
    font-size: 1.3rem;
    color: var(--text-color);
    margin: 0;
    line-height: 1.3;
    flex: 1;
  }

  .platform-badge {
    display: inline-block;
    padding: 6px 14px;
    border-radius: 30px;
    font-size: 0.8rem;
    font-weight: 700;
    background-color: var(--primary-color);
    color: white;
    margin-left: 10px;
    box-shadow: 0 2px 5px var(--shadow);
    text-transform: uppercase;
    letter-spacing: 0.5px;
  }

  .task-body {
    margin-bottom: 25px;
    position: relative;
    z-index: 2;
    flex-grow: 1;
  }

  .task-desc {
    font-size: 0.95rem;
    color: var(--text-color);
    margin-bottom: 15px;
    line-height: 1.5;
  }

  .task-amount {
    font-size: 1.2rem;
    margin: 10px 0;
    color: var(--primary-color);
    font-weight: 700;
    display: flex;
    align-items: center;
  }

  .task-amount::before {
    content: "₦";
    margin-right: 5px;
    font-size: 1rem;
  }

  .task-duration {
    font-size: 0.9rem;
    color: var(--text-color);
    margin-bottom: 10px;
    display: flex;
    align-items: center;
    opacity: 0.8;
  }

  .task-duration::before {
    content: "⏱️";
    margin-right: 8px;
  }

  .task-footer {
    display: flex;
    justify-content: space-between;
    position: relative;
    z-index: 2;
    gap: 10px;
  }

  .task-btn {
    padding: 12px 16px;
    background-color: var(--primary-color);
    color: white;
    border: none;
    border-radius: 30px;
    cursor: pointer;
    transition: var(--transition);
    font-weight: 600;
    flex: 1;
    text-align: center;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
    box-shadow: 0 4px 8px var(--shadow);
  }

  .task-btn:hover {
    background-color: var(--primary-dark);
    transform: translateY(-3px);
    box-shadow: 0 6px 12px var(--shadow);
  }

  .task-btn i {
    margin-right: 6px;
  }

  .text-danger {
    color: var(--primary-color);
    font-weight: 500;
  }

  .text-danger::before {
    content: "⚠️";
    margin-right: 5px;
  }

  .no-task {
    text-align: center;
    font-size: 1.2rem;
    color: var(--text-color);
    padding: 30px;
    background-color: rgba(230, 57, 70, 0.05);
    border-radius: var(--card-radius);
    margin: 20px 0;
    border: 1px dashed var(--primary-color);
  }

  .section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
  }

  .toggle-btn {
    background-color: var(--primary-color);
    border: none;
    color: white;
    padding: 8px 16px;
    border-radius: 30px;
    cursor: pointer;
    transition: var(--transition);
    font-weight: 500;
    box-shadow: 0 4px 8px var(--shadow);
  }

  .toggle-btn:hover {
    background-color: var(--primary-dark);
  }

  .completed-tasks {
    margin-top: 40px;
    padding-top: 20px;
    border-top: 1px solid rgba(230, 57, 70, 0.2);
  }

  .completed-task-card {
    background-color: rgba(230, 57, 70, 0.05);
    border: 2px solid rgba(230, 57, 70, 0.3);
  }

  .completed-task-card .task-amount {
    color: var(--primary-color);
  }

  .claimed-date {
    font-size: 0.85rem;
    color: var(--text-color);
    margin-top: 10px;
    display: flex;
    align-items: center;
    opacity: 0.8;
  }

  .claimed-date::before {
    content: "📅";
    margin-right: 8px;
  }
  
  @media (max-width: 1400px) {
    .task-card {
      flex: 0 0 calc(33.333% - 25px);
    }
  }
  
  @media (max-width: 1200px) {
    .task-card {
      flex: 0 0 calc(50% - 25px);
    }
  }
  
  @media (max-width: 768px) {
    .task-card {
      flex: 0 0 100%;
    }
    
    .nk-block-title {
      font-size: 2rem;
    }
    
    .tasks-container {
      padding: 0 10px;
    }
  }
  
  @media (max-width: 576px) {
    .task-card {
      flex: 0 0 100%;
    }
    
    .task-footer {
      flex-direction: column;
    }
    
    .task-btn {
      width: 100%;
    }
  }
</style>

<div class="nk-content">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head">
                    <div class="nk-block-head-between flex-wrap gap g-2">
                        <br>
                    </div>
                </div>
                
                <?php if (isset($taskMsg)) echo $taskMsg; ?>
                
                <div class="tasks-container">
                    
                    <div class="tasks-row">
                        <?php if ($numrow > 0): ?>
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <?php
                                    $id = $row['id'];
                                    $title = $row['title'];
                                    $description = $row['description'];
                                    $amount = $row['amount'];
                                    $platform = $row['social_platform'];
                                    $link = $row['link'];
                                    $durationType = $row['duration_type'];
                                    $durationValue = $row['duration_value'];
                                    $expirationDate = $row['expiration_date'];
                                    
                                    // Format duration
                                    $durationText = '';
                                    if ($durationType && $durationValue) {
                                        $durationText = $durationValue . ' ' . $durationType;
                                        if ($durationValue > 1) {
                                            $durationText .= 's';
                                        }
                                    }
                                    
                                    // Check if task is expiring soon
                                    $isExpiringSoon = false;
                                    if ($expirationDate) {
                                        $timeDiff = strtotime($expirationDate) - strtotime($currentDate);
                                        if ($timeDiff > 0 && $timeDiff <= 86400) { // 24 hours
                                            $isExpiringSoon = true;
                                        }
                                    }
                                ?>
                                <div class="task-card">
                                    <div class="task-header">
                                        <h5 class="task-title"><?= htmlspecialchars($title) ?></h5>
                                        <span class="platform-badge">
                                            <?= ucfirst($platform) ?>
                                        </span>
                                    </div>
                                    <div class="task-body">
                                        <p class="task-desc"><?= htmlspecialchars($description) ?></p>
                                        <p class="task-amount"><?= number_format($amount, 2) ?></p>
                                        <?php if ($durationText): ?>
                                            <p class="task-duration"><?= $durationText ?></p>
                                        <?php endif; ?>
                                        <?php if ($isExpiringSoon): ?>
                                            <p class="task-duration text-danger">Expires soon: <?= date('M j, H:i', strtotime($expirationDate)) ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <div class="task-footer">
                                        <a href="<?= htmlspecialchars($link) ?>" target="_blank" class="task-btn">
                                            <i class="fas fa-external-link-alt"></i> Perform Task
                                        </a>
                                        <form method="POST" style="display: inline; flex: 1;">
                                            <input type="hidden" name="taskId" value="<?= $id ?>">
                                            <button type="submit" name="claimTask" class="task-btn">
                                                <i class="fas fa-check-circle"></i> Claim Reward
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <div class="no-task">No tasks available at the moment. Check back later.</div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Completed Tasks Section -->
                    <div class="completed-tasks">
                        <div class="section-header">
                            <h3>Completed Tasks</h3>
                            <button class="toggle-btn" id="toggleCompleted">Show/Hide</button>
                        </div>
                        <div class="tasks-row" id="completedTasksRow" style="display: none;">
                            <?php if ($completedResult->num_rows > 0): ?>
                                <?php while ($row = $completedResult->fetch_assoc()): ?>
                                    <?php
                                        $id = $row['id'];
                                        $title = $row['title'];
                                        $amount = $row['amount'];
                                        $platform = $row['social_platform'];
                                        $claimedAt = $row['claimed_at'];
                                    ?>
                                    <div class="task-card completed-task-card">
                                        <div class="task-header">
                                            <h5 class="task-title"><?= htmlspecialchars($title) ?></h5>
                                            <span class="platform-badge">
                                                <?= ucfirst($platform) ?>
                                            </span>
                                        </div>
                                        <div class="task-body">
                                            <p class="task-amount"><?= number_format($amount, 2) ?></p>
                                            <p class="claimed-date">Completed on: <?= date('M j, Y H:i', strtotime($claimedAt)) ?></p>
                                        </div>
                                    </div>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <div class="no-task">You haven't completed any tasks yet.</div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Include Font Awesome for icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

<script>
document.addEventListener('DOMContentLoaded', function() {
    const toggleBtn = document.getElementById('toggleCompleted');
    const completedRow = document.getElementById('completedTasksRow');
    
    toggleBtn.addEventListener('click', function() {
        if (completedRow.style.display === 'none') {
            completedRow.style.display = 'flex';
            toggleBtn.textContent = 'Hide';
        } else {
            completedRow.style.display = 'none';
            toggleBtn.textContent = 'Show';
        }
    });
});
</script>

<?php include "includes/footer.php"; ?>