<?php
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/includes/generalinclude.php";
$ptitle = "Top Earners";
include "includes/header.php"
?>
<style>
    :root {
        --primary-red: #ff3131;
        --dark-red: #cc0000;
        --black: #000000;
        --white: #ffffff;
        --light-gray: #f8f9fa;
        --medium-gray: #e9ecef;
    }
    
    body {
        background-color: var(--light-gray);
        color: var(--black);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    .nk-content {
        padding: 1.5rem 0;
    }
    
    .nk-block-head {
        margin-bottom: 2rem;
    }
    
    .nk-block-title {
        color: var(--black);
        font-weight: 700;
        font-size: 1.75rem;
        margin-bottom: 0.5rem;
    }
    
    .breadcrumb {
        background-color: transparent;
        padding: 0;
        margin: 0;
    }
    
    .breadcrumb-item a {
        color: var(--primary-red);
        text-decoration: none;
        font-weight: 500;
    }
    
    .breadcrumb-item a:hover {
        color: var(--dark-red);
        text-decoration: underline;
    }
    
    .breadcrumb-item.active a {
        color: var(--black);
    }
    
    .card {
        border: none;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        margin-bottom: 1.5rem;
        overflow: hidden;
        background-color: var(--white);
    }
    
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
    }
    
    .card-header {
        background-color: var(--white);
        border-bottom: 1px solid var(--medium-gray);
        padding: 1rem 1.5rem;
    }
    
    .card-body {
        padding: 1.5rem;
    }
    
    .card-title {
        color: var(--black);
        font-weight: 700;
        font-size: 1.2rem;
        margin: 0;
    }
    
    .card-tools {
        margin-left: auto;
    }
    
    .btn-soft {
        background-color: rgba(255, 49, 49, 0.1);
        color: var(--primary-red);
        border: none;
        border-radius: 8px;
        padding: 0.5rem 1rem;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    
    .btn-soft:hover {
        background-color: rgba(255, 49, 49, 0.2);
        color: var(--dark-red);
    }
    
    .table {
        color: var(--black);
        margin-bottom: 0;
    }
    
    .table thead th {
        color: var(--black);
        font-weight: 600;
        border-bottom: 2px solid var(--medium-gray);
        padding: 1rem;
        background-color: var(--white);
    }
    
    .table tbody tr {
        border-bottom: 1px solid var(--medium-gray);
        transition: background-color 0.3s ease;
        background-color: var(--white);
    }
    
    .table tbody tr:hover {
        background-color: rgba(255, 49, 49, 0.05);
    }
    
    .table tbody tr:last-child {
        border-bottom: none;
    }
    
    .table tbody td {
        padding: 1rem;
    }
    
    .media-text .title {
        color: var(--black);
        font-weight: 500;
        font-size: 1rem;
    }
    
    .text-success {
        color: var(--primary-red) !important;
        font-weight: 700;
    }
    
    .info-box {
        background: linear-gradient(135deg, rgba(255, 49, 49, 0.1) 0%, rgba(255, 49, 49, 0.05) 100%);
        border-left: 4px solid var(--primary-red);
        border-radius: 8px;
        padding: 1.5rem;
        margin-bottom: 1.5rem;
    }
    
    .info-box h5 {
        color: var(--primary-red);
        font-weight: 700;
        font-size: 1.2rem;
        margin-top: 0;
        margin-bottom: 1rem;
    }
    
    .info-box p {
        margin-bottom: 0.75rem;
        font-size: 0.95rem;
    }
    
    .info-box p:last-child {
        margin-bottom: 0;
    }
    
    .info-box strong {
        color: var(--primary-red);
    }
    
    .info-box .icon {
        font-size: 2rem;
        color: var(--primary-red);
        margin-bottom: 1rem;
        display: block;
    }
    
    .trophy-icon {
        color: var(--primary-red);
        margin-right: 0.5rem;
    }
    
    .rank-badge {
        background-color: var(--primary-red);
        color: var(--white);
        border-radius: 20px;
        padding: 0.25rem 0.75rem;
        font-size: 0.8rem;
        font-weight: 600;
        display: inline-block;
        margin-left: 0.5rem;
    }
    
    .no-data {
        text-align: center;
        padding: 2rem;
        color: var(--medium-gray);
    }
    
    .no-data i {
        font-size: 2rem;
        margin-bottom: 0.5rem;
        display: block;
    }
    
    @media (max-width: 768px) {
        .nk-content {
            padding: 1rem 0;
        }
        
        .card-body {
            padding: 1.25rem;
        }
        
        .nk-block-title {
            font-size: 1.5rem;
        }
        
        .table thead th, .table tbody td {
            padding: 0.75rem 0.5rem;
        }
        
        .card-title {
            font-size: 1rem;
        }
        
        .info-box {
            padding: 1rem;
        }
    }
</style>

<div class="nk-content px-0">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head">
                    <div class="nk-block-head-between flex-wrap gap g-2">
                        
                    </div>
                </div>
                
                <div class="row g-gs">
                    <div class="col-12">
                        <div class="card h-100">
                            <div class="card-header">
                                <div class="d-flex align-items-center justify-content-between">
                                    <h4 class="card-title">
                                        <em class="icon ni ni-trophy-fill trophy-icon"></em>
                                        <?php echo $sitename ?> Top Earners
                                    </h4>
                                    <div class="card-tools">
                                        <a href="" class="btn btn-sm btn-soft btn-secondary">
                                            <span>View List</span> 
                                            <em class="icon ni ni-chevron-right"></em>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                
                                
                                <div class="table-responsive">
                                    <table class="table table-middle mb-0">
                                        <thead>
                                            <tr>
                                                <th><span class="overline-title">Rank</span></th>
                                                <th><span class="overline-title">Names</span></th>
                                                <th class="text-end"><span class="overline-title">Earnings</span></th>
                                                <th class="text-end"><span class="overline-title">Total Ref</span></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            $time=strtotime("+7 days", time());
                                            $sql=$link->prepare("SELECT * FROM users WHERE referralfunds > 0 AND YEARWEEK(STR_TO_DATE(date, '%d-%m-%Y')) = YEARWEEK(NOW()) ORDER BY CAST(referralfunds AS UNSIGNED) DESC LIMIT 20");
                                            $sql->execute();
                                            $result=$sql->get_result();                  
                                            $numrow=$result->num_rows;
                                            if($numrow > 0){
                                                $id=0;
                                                while($row=$result->fetch_assoc()){
                                                    $id++;
                                                    $refFunds=$row['referralfunds'];
                                                    $userName=$row['username']; 
                                                    
                                                    $sql_ref = $link->prepare("SELECT COUNT(*) AS totalRef FROM referrals WHERE referral = ? AND YEARWEEK(STR_TO_DATE(date, '%d-%m-%Y')) = YEARWEEK(NOW()) ");
                                                    $sql_ref->bind_param("s", $userName);
                                                    $sql_ref->execute();
                                                    $result_ref = $sql_ref->get_result();
                                                    $row_ref = $result_ref->fetch_assoc();
                                                    $totalRef = $row_ref["totalRef"];
                                            ?>
                                                <tr class="pointer">
                                                    <td>
                                                        <div class="media-text">
                                                            <?php if($id <= 3) { ?>
                                                                <span class="rank-badge">#<?php echo $id ?></span>
                                                            <?php } else { ?>
                                                                <span class="text-muted"><?php echo $id ?></span>
                                                            <?php } ?>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="media-text">
                                                            <span class="title"><?php echo $userName ?></span>
                                                        </div>
                                                    </td>
                                                    <td class="text-end">
                                                        <div class="media-text">
                                                            <span class="title text-success">₦<?php echo number_format((int)$refFunds) ?></span>
                                                        </div>
                                                    </td>
                                                    <td class="text-end">
                                                        <div class="media-text">
                                                            <span class="title text-success"><?php echo number_format((int)$totalRef) ?></span>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php } 
                                            } else { ?>
                                                <tr>
                                                    <td colspan="4" class="no-data">
                                                        <em class="icon ni ni-user-cross"></em>
                                                        <p>No top earners data available</p>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
           
<?php include "includes/footer.php" ?>