<?php
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/includes/generalinclude.php";
// Check if user is logged in
if (!isset($_SESSION['username'])) {
    header("location: ../login");
    exit;
}
$username = $_SESSION['username'];
$genMsg = "";
// Fetch current user data
$sql = $link->prepare("SELECT * FROM users WHERE username=?");
$sql->bind_param("s", $username);
$sql->execute();
$result = $sql->get_result();
$user = $result->fetch_assoc();
$currentPlan = $user['plantype'];
// Handle upgrade form submission
if (isset($_POST['upgrade'])) {
    $coupon = trim($_POST['coupon']);
    
    // Validate coupon
    if (empty($coupon)) {
        $genMsg = sendResponse("error", "Please enter a coupon code");
    } else {
        // Check if coupon exists and is active
        $sql = $link->prepare("SELECT * FROM coupons WHERE coupon=? AND type='plan_b' AND status='active'");
        $sql->bind_param("s", $coupon);
        $sql->execute();
        $result = $sql->get_result();
        $numrow = $result->num_rows;
        
        if ($numrow == 0) {
            $genMsg = sendResponse("error", "Invalid or inactive coupon code");
        } else {
            // Check if coupon has been used
            $sql = $link->prepare("SELECT * FROM users WHERE coupon=?");
            $sql->bind_param("s", $coupon);
            $sql->execute();
            $result = $sql->get_result();
            $numrow_used = $result->num_rows;
            
            if ($numrow_used > 0) {
                $genMsg = sendResponse("error", "Coupon code has already been used");
            } else {
                // Update user's plan to plan_b
                $newTime = strtotime("+3000 days", time());
                $newPlan = "plan_b";
                
                $sql = $link->prepare("UPDATE users SET plantype=?, time=?, coupon=? WHERE username=?");
                $sql->bind_param("ssss", $newPlan, $newTime, $coupon, $username);
                if ($sql->execute()) {
                    // Mark coupon as used
                    $sql = $link->prepare("UPDATE coupons SET status='used' WHERE coupon=?");
                    $sql->bind_param("s", $coupon);
                    $sql->execute();
                    
                    // Refresh user data
                    $sql = $link->prepare("SELECT * FROM users WHERE username=?");
                    $sql->bind_param("s", $username);
                    $sql->execute();
                    $result = $sql->get_result();
                    $user = $result->fetch_assoc();
                    $currentPlan = $user['plantype'];
                    
                    $genMsg = sendResponse("success", "Upgrade successful! You are now on Plan B.");
                } else {
                    $genMsg = sendResponse("error", "Upgrade failed. Please try again.");
                }
            }
        }
    }
}
$ptitle = "Upgrade Plan";
include "includes/header.php";
?>
<style>
    :root {
        --primary-red: #ff3131;
        --dark-red: #cc0000;
        --black: #000000;
        --white: #ffffff;
        --light-gray: #f8f9fa;
        --medium-gray: #e9ecef;
        --success: #28a745;
        --blue: #007bff;
        --gradient: linear-gradient(135deg, #ff3131 0%, #ff6b6b 100%);
    }
    
    body {
        background-color: var(--light-gray);
        color: var(--black);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        line-height: 1.6;
    }
    
    .nk-content {
        padding: 2rem 0;
    }
    
    .nk-block-head {
        margin-bottom: 2.5rem;
    }
    
    .nk-block-title {
        font-size: 2.25rem;
        font-weight: 700;
        color: var(--black);
        margin-bottom: 0.5rem;
    }
    
    .breadcrumb {
        background-color: transparent;
        padding: 0;
        margin: 0;
        font-size: 0.9rem;
    }
    
    .breadcrumb-item a {
        color: var(--primary-red);
        text-decoration: none;
        font-weight: 500;
        transition: color 0.3s ease;
    }
    
    .breadcrumb-item a:hover {
        color: var(--dark-red);
    }
    
    .breadcrumb-item.active a {
        color: var(--black);
    }
    
    .card {
        border: none;
        border-radius: 16px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        margin-bottom: 2rem;
        overflow: hidden;
        background-color: var(--white);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.12);
    }
    
    .card-body {
        padding: 2rem;
    }
    
    .plan-badge {
        display: inline-block;
        padding: 0.5rem 1.25rem;
        border-radius: 30px;
        font-weight: 700;
        font-size: 1rem;
        text-transform: uppercase;
        letter-spacing: 1px;
        margin-bottom: 1.5rem;
        transition: all 0.3s ease;
    }
    
    .plan-a {
        background-color: #e9ecef;
        color: var(--black);
        border: 2px solid #dee2e6;
    }
    
    .plan-b {
        background: var(--gradient);
        color: var(--white);
        border: 2px solid var(--primary-red);
        box-shadow: 0 4px 15px rgba(255, 49, 49, 0.3);
    }
    
    .upgrade-form {
        background: linear-gradient(145deg, #f8f9fa, #ffffff);
        border-radius: 16px;
        padding: 2rem;
        border: 1px solid var(--medium-gray);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
    }
    
    .upgrade-form:hover {
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    }
    
    .form-label {
        color: var(--black);
        font-weight: 600;
        margin-bottom: 0.75rem;
        font-size: 1.1rem;
    }
    
    .form-control {
        border: 2px solid #e0e0e0;
        border-radius: 12px;
        padding: 0.875rem 1.25rem;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: var(--white);
        height: auto;
    }
    
    .form-control:focus {
        border-color: var(--primary-red);
        box-shadow: 0 0 0 0.2rem rgba(255, 49, 49, 0.25);
        outline: none;
    }
    
    .btn-primary {
        background: var(--gradient);
        border: none;
        border-radius: 12px;
        padding: 0.875rem 1.5rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 1px;
        transition: all 0.3s ease;
        color: var(--white);
        font-size: 1rem;
        box-shadow: 0 4px 15px rgba(255, 49, 49, 0.3);
    }
    
    .btn-primary:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(255, 49, 49, 0.4);
        background: var(--gradient);
    }
    
    .btn-primary:active {
        transform: translateY(1px);
    }
    
    .btn-outline {
        background: transparent;
        border: 2px solid var(--primary-red);
        border-radius: 12px;
        padding: 0.875rem 1.5rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 1px;
        transition: all 0.3s ease;
        color: var(--primary-red);
        font-size: 1rem;
        margin-top: 1rem;
        width: 100%;
    }
    
    .btn-outline:hover {
        background: var(--primary-red);
        color: var(--white);
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(255, 49, 49, 0.4);
    }
    
    .feature-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }
    
    .feature-list li {
        padding: 1rem 0;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        display: flex;
        align-items: flex-start;
        transition: all 0.3s ease;
    }
    
    .feature-list li:hover {
        padding-left: 0.5rem;
    }
    
    .feature-list li:last-child {
        border-bottom: none;
    }
    
    .feature-icon {
        color: var(--primary-red);
        margin-right: 1rem;
        font-size: 1.5rem;
        flex-shrink: 0;
    }
    
    .feature-text {
        flex-grow: 1;
    }
    
    .feature-title {
        font-weight: 700;
        margin-bottom: 0.25rem;
        color: var(--black);
    }
    
    .feature-desc {
        color: #6c757d;
        font-size: 0.95rem;
    }
    
    .response {
        margin-bottom: 2rem;
    }
    
    .plan-comparison {
        margin-top: 3rem;
    }
    
    .section-title {
        font-size: 1.75rem;
        font-weight: 700;
        margin-bottom: 2rem;
        color: var(--black);
        text-align: center;
        position: relative;
        padding-bottom: 1rem;
    }
    
    .section-title:after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 80px;
        height: 4px;
        background: var(--gradient);
        border-radius: 2px;
    }
    
    .plan-card {
        border: 2px solid var(--medium-gray);
        border-radius: 16px;
        padding: 2rem;
        margin-bottom: 1.5rem;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
        background-color: var(--white);
    }
    
    .plan-card:hover {
        border-color: var(--primary-red);
        transform: translateY(-8px);
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
    }
    
    .plan-card.active {
        border-color: var(--primary-red);
        background: linear-gradient(145deg, rgba(255, 49, 49, 0.03), rgba(255, 107, 107, 0.05));
    }
    
    .plan-card.active:before {
        content: 'Current Plan';
        position: absolute;
        top: 1rem;
        right: -2rem;
        background: var(--gradient);
        color: var(--white);
        padding: 0.25rem 3rem;
        transform: rotate(45deg);
        font-weight: 700;
        font-size: 0.75rem;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    
    .plan-title {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 1rem;
        color: var(--black);
    }
    
    .plan-price {
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--primary-red);
        margin-bottom: 1.5rem;
    }
    
    .plan-features {
        margin-bottom: 1.5rem;
    }
    
    .plan-features ul {
        list-style: none;
        padding: 0;
    }
    
    .plan-features li {
        padding: 0.75rem 0;
        display: flex;
        align-items: center;
        font-size: 0.95rem;
    }
    
    .plan-features li i {
        color: var(--success);
        margin-right: 0.75rem;
        font-size: 1.25rem;
    }
    
    .plan-features li.negative i {
        color: #dc3545;
    }
    
    .alert-success {
        background-color: rgba(40, 167, 69, 0.1);
        border-left: 4px solid var(--success);
        color: var(--success);
        padding: 1rem 1.5rem;
        border-radius: 8px;
        font-weight: 500;
    }
    
    .upgrade-header {
        text-align: center;
        margin-bottom: 2rem;
    }
    
    .upgrade-header h4 {
        font-size: 1.75rem;
        font-weight: 700;
        color: var(--black);
        margin-bottom: 0.5rem;
    }
    
    .upgrade-header p {
        color: #6c757d;
        font-size: 1.1rem;
    }
    
    .current-plan-section {
        background: linear-gradient(145deg, #f8f9fa, #ffffff);
        border-radius: 16px;
        padding: 2rem;
        margin-bottom: 2rem;
        border: 1px solid var(--medium-gray);
        text-align: center;
    }
    
    .current-plan-title {
        font-size: 1.25rem;
        font-weight: 600;
        margin-bottom: 1rem;
        color: #6c757d;
    }
    
    .why-upgrade {
        background: linear-gradient(145deg, #ffffff, #f8f9fa);
        border-radius: 16px;
        padding: 2rem;
        border: 1px solid var(--medium-gray);
    }
    
    .why-upgrade h4 {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 1.5rem;
        color: var(--black);
        text-align: center;
    }
    
    .divider {
        display: flex;
        align-items: center;
        margin: 1.5rem 0;
    }
    
    .divider-line {
        flex-grow: 1;
        height: 1px;
        background-color: var(--medium-gray);
    }
    
    .divider-text {
        padding: 0 1rem;
        color: #6c757d;
        font-size: 0.875rem;
        font-weight: 500;
    }
    
    @media (max-width: 768px) {
        .nk-content {
            padding: 1rem 0;
        }
        
        .card-body {
            padding: 1.5rem;
        }
        
        .plan-card {
            padding: 1.5rem;
        }
        
        .plan-price {
            font-size: 2rem;
        }
        
        .nk-block-title {
            font-size: 1.75rem;
        }
        
        .feature-list li {
            padding: 0.75rem 0;
        }
    }
</style>
<div class="nk-content">
    <div class="container px-0">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head">
                    <div class="nk-block-head-between flex-wrap gap g-2 mt-4">
                        <div class="nk-block-head-content">
                           
                        </div>
                    </div>
                </div>
                
                <div class="response"><?php echo $genMsg ?></div>
                
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-5">
                                <div class="current-plan-section">
                                    <div class="current-plan-title">Your Current Plan</div>
                                    <div class="d-flex justify-content-center mb-4">
                                        <span class="plan-badge <?php echo $currentPlan == 'plan_a' ? 'plan-a' : 'plan-b'; ?>">
                                            <?php echo strtoupper($currentPlan); ?>
                                        </span>
                                    </div>
                                    
                                    <?php if ($currentPlan == 'plan_a'): ?>
                                        <div class="upgrade-form">
                                            <div class="upgrade-header">
                                                <h4>Upgrade to Plan B</h4>
                                                <p>Unlock premium features with a coupon code</p>
                                            </div>
                                            
                                            <form method="POST">
                                                <div class="form-group mb-4">
                                                    <label for="coupon" class="form-label">Coupon Code</label>
                                                    <input type="text" class="form-control" id="coupon" name="coupon" placeholder="Enter your coupon code" required>
                                                </div>
                                                <button type="submit" class="btn btn-primary w-100" name="upgrade">
                                                    Upgrade Now
                                                </button>
                                            </form>
                                            
                                            <div class="divider">
                                                <div class="divider-line"></div>
                                                <div class="divider-text">OR</div>
                                                <div class="divider-line"></div>
                                            </div>
                                            
                                            <a href="/coupons.php" class="btn btn-outline">
                                                Purchase Activation Key
                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <div class="alert alert-success">
                                            <i class="icon ni ni-check-circle-fill"></i> You're already on our premium Plan B. Enjoy all the benefits!
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-md-7">
                                <div class="why-upgrade">
                                    <h4>Why Upgrade to Plan B?</h4>
                                    <ul class="feature-list">
                                        <li>
                                            <div class="feature-icon">
                                                <i class="icon ni ni-coins"></i>
                                            </div>
                                            <div class="feature-text">
                                                <div class="feature-title">Higher Earnings</div>
                                                <div class="feature-desc">Increased referral bonuses and daily rewards</div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="feature-icon">
                                                <i class="icon ni ni-calendar"></i>
                                            </div>
                                            <div class="feature-text">
                                                <div class="feature-title">Extended Validity</div>
                                                <div class="feature-desc">Unlimited days account validity vs limited acces on the free plan</div>
                                            </div>
                                        </li>
                                       
                                        <li>
                                            <div class="feature-icon">
                                                <i class="icon ni ni-lock"></i>
                                            </div>
                                            <div class="feature-text">
                                                <div class="feature-title">Exclusive Features</div>
                                                <div class="feature-desc">Access to premium tools and analytics</div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="feature-icon">
                                                <i class="icon ni ni-file-text"></i>
                                            </div>
                                            <div class="feature-text">
                                                <div class="feature-title">Advanced Reports</div>
                                                <div class="feature-desc">Detailed earnings and activity reports</div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="feature-icon">
                                                <i class="icon ni ni-cc-alt"></i>
                                            </div>
                                            <div class="feature-text">
                                                <div class="feature-title">Higher Withdrawal Limits</div>
                                                <div class="feature-desc">Increased transaction limits</div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include "includes/footer.php"; ?>