<?php
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/actions/withdraw.php";
$ptitle = "Withdrawal";
include "includes/header.php"
?>
<style>
    :root {
        --primary-red: #ff3131;
        --dark-red: #cc0000;
        --black: #000000;
        --white: #ffffff;
        --light-gray: #f8f9fa;
        --medium-gray: #e9ecef;
    }
    
    body {
        background-color: var(--white);
        color: var(--black);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    .nk-content {
        padding: 1.5rem 0;
        background-color: var(--light-gray);
    }
    
    .nk-block-head {
        margin-bottom: 2rem;
    }
    
    .nk-block-title {
        color: var(--black);
        font-weight: 700;
        font-size: 1.75rem;
        margin-bottom: 0.5rem;
    }
    
    .breadcrumb {
        background-color: transparent;
        padding: 0;
        margin: 0;
    }
    
    .breadcrumb-item a {
        color: var(--primary-red);
        text-decoration: none;
        font-weight: 500;
    }
    
    .breadcrumb-item a:hover {
        color: var(--dark-red);
        text-decoration: underline;
    }
    
    .breadcrumb-item.active a {
        color: var(--black);
    }
    
    .card {
        border: none;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        margin-bottom: 1.5rem;
        overflow: hidden;
        background-color: var(--white);
    }
    
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
    }
    
    .card-body {
        padding: 1.5rem;
    }
    
    .card-header {
        background-color: var(--white);
        border-bottom: 1px solid var(--medium-gray);
        padding: 1rem 1.5rem;
    }
    
    .form-label {
        color: var(--black);
        font-weight: 600;
        margin-bottom: 0.5rem;
    }
    
    .form-control {
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        padding: 0.75rem 1rem;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: var(--white);
    }
    
    .form-control:focus {
        border-color: var(--primary-red);
        box-shadow: 0 0 0 0.2rem rgba(255, 49, 49, 0.25);
    }
    
    .btn-primary {
        background-color: var(--primary-red);
        border: none;
        border-radius: 8px;
        padding: 0.75rem 1.5rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.3s ease;
        color: var(--white);
    }
    
    .btn-primary:hover {
        background-color: var(--dark-red);
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(255, 49, 49, 0.4);
    }
    
    .table {
        color: var(--black);
    }
    
    .table tbody tr {
        border-bottom: 1px solid var(--medium-gray);
        transition: background-color 0.3s ease;
        background-color: var(--white);
    }
    
    .table tbody tr:hover {
        background-color: rgba(255, 49, 49, 0.05);
    }
    
    .table tbody tr:last-child {
        border-bottom: none;
    }
    
    .media-text .title {
        color: var(--black);
        font-weight: 500;
        font-size: 1rem;
    }
    
    .media-text .small {
        font-size: 0.8rem;
    }
    
    .text-warning {
        color: #ffc107 !important;
    }
    
    .text-danger {
        color: #dc3545 !important;
    }
    
    .text-info {
        color: #17a2b8 !important;
    }
    
    .text-success {
        color: #28a745 !important;
    }
    
    .text-muted {
        color: #6c757d !important;
    }
    
    .response {
        margin-bottom: 1.5rem;
    }
    
    .fs-10 {
        font-size: 12px;
    }
    
    .pointer {
        cursor: pointer;
    }
    
    .withdraw-icon {
        color: var(--primary-red);
        margin-right: 0.5rem;
    }
    
    .history-icon {
        color: var(--primary-red);
        margin-right: 0.5rem;
    }
    
    .card-accent {
        border-top: 4px solid var(--primary-red);
    }
    
    /* Locked state styles */
    .locked-card {
        background-color: var(--white);
        border-radius: 12px;
        padding: 3rem;
        text-align: center;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--medium-gray);
    }
    
    .locked-icon {
        font-size: 4rem;
        color: var(--primary-red);
        margin-bottom: 1.5rem;
    }
    
    .locked-title {
        font-size: 1.75rem;
        font-weight: 700;
        color: var(--black);
        margin-bottom: 1rem;
    }
    
    .locked-description {
        color: var(--black);
        opacity: 0.8;
        margin-bottom: 2rem;
        max-width: 500px;
        margin-left: auto;
        margin-right: auto;
    }
    
    .upgrade-btn {
        background-color: var(--primary-red);
        color: var(--white);
        border: none;
        border-radius: 8px;
        padding: 0.8rem 2rem;
        font-weight: 600;
        font-size: 1.1rem;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
    }
    
    .upgrade-btn:hover {
        background-color: var(--dark-red);
        transform: translateY(-3px);
        box-shadow: 0 6px 15px rgba(255, 49, 49, 0.4);
    }
    
    .upgrade-btn i {
        margin-right: 0.5rem;
    }
    
    @media (max-width: 768px) {
        .nk-content {
            padding: 1rem 0;
        }
        
        .card-body {
            padding: 1.25rem;
        }
        
        .nk-block-title {
            font-size: 1.5rem;
        }
        
        .locked-card {
            padding: 2rem 1.5rem;
        }
        
        .locked-icon {
            font-size: 3rem;
        }
        
        .locked-title {
            font-size: 1.5rem;
        }
    }
</style>
<div class="nk-content">
    <div class="container px-0">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head">
                    <div class="nk-block-head-between flex-wrap gap g-2 mt-4">
                        
                    </div>
                </div>
                
                <div class="response"><?php echo $genMsg ?></div>
                
                <?php if($planType == "plan_b"): ?>
                <!-- Locked state for FREE plan -->
                <div class="locked-card">
                    <em class="icon ni ni-lock-fill locked-icon"></em>
                    <h3 class="locked-title">Withdrawal Locked</h3>
                    <p class="locked-description">
                        Upgrade to PAID plan to unlock withdrawals and access your earnings.
                    </p>
                    <a href="upgrade.php" class="upgrade-btn">
                        <em class="icon ni ni-arrow-up-circle"></em>
                        Upgrade Now
                    </a>
                </div>
                <?php else: ?>
                <!-- Withdrawal form for PAID and Student plans -->
                <div class="card card-accent">
                    <div class="card-body">
                        <h4 class="mb-4" style="color: var(--black); font-weight: 600;">
                            <em class="icon ni ni-money-alt withdraw-icon"></em>
                            Withdraw Funds
                        </h4>
                        <form class="row gx-gs gy-4" method="POST">
                            <div class="col-12">
                                <div class="form-group">
                                    <div class="form-control-wrap">
                                        <label for="wallet" class="form-label mb-0">Select Earnings</label>
                                        <select class="form-control" name="wallet" id="wallet">
                                            <option value="" selected disabled>Select balance</option>
                                            <option value="activity">Activity Balance ₦<?php echo number_format((int)$funds, 2) ?></option>
                                            <option value="referral">Referral Balance ₦<?php echo number_format((int)$referralFunds, 2) ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <div class="form-control-wrap">
                                        <label for="amount" class="form-label mb-0">Amount</label>
                                        <input type="tel" class="form-control" name="amount" id="amount" placeholder="Enter amount">
                                    </div>
                                </div>
                            </div> 
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary w-100" name="withdraw">Withdraw Funds</button>
                            </div>
                        </form>
                    </div>
                </div>
                
                <div class="card mt-4 card-accent">
                    <div class="card-header">
                        <h5 class="mb-0" style="color: var(--black); font-weight: 600;">
                            <em class="icon ni ni-file-text history-icon"></em>
                            Withdrawal History
                        </h5>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <tbody>
                                    <?php
                                    $sql = $link->prepare("SELECT * FROM withdrawals WHERE username=? ORDER BY id DESC");
                                    $sql->bind_param("s", $username);
                                    $sql->execute();
                                    $result = $sql->get_result();
                                    $numrow = $result->num_rows;
                                    if ($numrow > 0) {
                                        $id = 0;
                                        while ($row = $result->fetch_assoc()) {
                                            $id++;
                                            $wallet = $row['type'];
                                            $wallet="Available";
                                            $amount = $row['amount'];
                                            $date = $row['date'];
                                            $desc = $row['description'];
                                            $status = $row['status'];
                                            if ($status == "inprogress") {
                                                $statusColor = "warning";
                                            } else if ($status == "rejected") {
                                                $statusColor = "danger";
                                            } 
                                            else if ($status == "reversed") {
                                                $statusColor = "info";
                                            }else {
                                                $statusColor = "success";
                                            }
                                    ?>
                                            <tr class="pointer">
                                                <td class="tb-col py-3">
                                                    <div class="media-group">
                                                        <div class="media-text">
                                                            <a class="title d-block"><?php echo ucwords($wallet) ?> Balance</a>
                                                            <span class="small text-<?php echo $statusColor ?>"><?php echo $status ?></span>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="tb-col tb-col-end py-3">
                                                    <div class="media-text text-end">
                                                        <a class="title text-muted d-block">₦<?php echo number_format($amount, 2) ?></a>
                                                        <span class="text smaller text-muted"><?php echo $date ?></span>
                                                    </div>
                                                </td>
                                            </tr>
                                    <?php }
                                    } else {
                                        echo '<tr><td colspan="2" class="text-center py-4 text-muted">No withdrawal history found</td></tr>';
                                    } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php include "includes/footer.php" ?>